#!/bin/bash

model_name="EleutherAI/gpt-neo-125m"
model_name_split=$(echo "$model_name" | awk -F/ '{print $NF}')

k_range=(18 32 48 64)
k_range_str=$(printf "[%s]" "$(printf ", %s" "${k_range[@]}" | cut -c3-)")
data_path="/data" 
save_dir="./outputs" 

seeds_str=$(printf "[%s]" "$(printf ", %s" "${seeds[@]}" | cut -c3-)")

epoch_range=(10)
lr_full=0.00003
lr_ftlayer=.0001
lr_lmhead=.0001
lr_lmadaptor=.001


epoch_range_str=$(printf "[%s]" "$(printf ", %s" "${epoch_range[@]}" | cut -c3-)")

run_id=$(echo "$path_to_adaptor" | awk -F/ '{print $NF}')
prefix=""

datasets=("sms_spam")
key="text"

output_dir="./evals" 
path_to_script=./baselines/finetune_utils_text.py


for d in "${datasets[@]}"
do
    python $path_to_script \
        --model_name=$model_name \
        --k_range="$k_range_str" \
        --output_dir=$output_dir \
        --epoch_range="[10]" \
        --dataset=$d \
        --eval_dataset=$d \
        --do_eval=True \
        --learning_rate=$lr_full \
        --ft_full=True \
        --data_path=$data_path \
        --save_dir=$save_dir

    python $path_to_script \
        --model_name=$model_name \
        --k_range="$k_range_str" \
        --output_dir=$output_dir \
        --epoch_range="[5]" \
        --dataset=$d \
        --eval_dataset=$d \
        --do_eval=True \
        --learning_rate=$lr_ftlayer \
        --data_path=$data_path \
        --ft_layers=True  \
        --save_dir=$save_dir

    python $path_to_script \
        --model_name=$model_name \
        --k_range="$k_range_str" \
        --output_dir=$output_dir \
        --epoch_range="[10]" \
        --dataset=$d \
        --eval_dataset=$d \
        --do_eval=True \
        --learning_rate=$lr_lmhead \
        --data_path=$data_path \
        --ft_head=True \
        --save_dir=$save_dir
    
    python $path_to_script \
        --model_name=$model_name \
        --k_range="$k_range_str" \
        --output_dir=$output_dir \
        --epoch_range="[50]" \
        --dataset=$d \
        --eval_dataset=$d \
        --do_eval=True \
        --learning_rate=$lr_lmadaptor \
        --ft_adaptor=True \
        --data_path=$data_path \
        --save_dir=$save_dir	
    
done
    




