#[data]_[model]
CUDA_VISIBLE_DEVICES=0 python3 attack_classification.py --dataset_path data/imdb --target_model bert --target_model_path checkpoints/ag --max_seq_length 256 --batch_size 32 --nclasses 4 --counter_fitting_embeddings_path embeddings/counter-fitted-vectors.txt --counter_fitting_cos_sim_path ./cos_sim_counter_fitting.npy --USE_cache_path '' --output_dir adv_results/imdb_ag/ --data_size 100

CUDA_VISIBLE_DEVICES=1 python3 attack_classification.py --dataset_path data/imdb --target_model bert --target_model_path checkpoints/fake --max_seq_length 256 --batch_size 32 --nclasses 2 --counter_fitting_embeddings_path embeddings/counter-fitted-vectors.txt --counter_fitting_cos_sim_path ./cos_sim_counter_fitting.npy --USE_cache_path '' --output_dir adv_results/imdb_fake/ --data_size 100

CUDA_VISIBLE_DEVICES=3 python3 attack_classification.py --dataset_path data/imdb --target_model bert --target_model_path checkpoints/yelp --max_seq_length 256 --batch_size 32 --nclasses 2 --counter_fitting_embeddings_path embeddings/counter-fitted-vectors.txt --counter_fitting_cos_sim_path ./cos_sim_counter_fitting.npy --USE_cache_path '' --output_dir adv_results/imdb_yelp/ --data_size 100

CUDA_VISIBLE_DEVICES=3 python3 attack_classification.py --dataset_path data/imdb --target_model bert --target_model_path checkpoints/imdb --max_seq_length 256 --batch_size 32 --nclasses 2 --counter_fitting_embeddings_path embeddings/counter-fitted-vectors.txt --counter_fitting_cos_sim_path ./cos_sim_counter_fitting.npy --USE_cache_path '' --output_dir adv_results/imdb_imdb/ --data_size 100


# transfer attack
python3 eval_classification.py --dataset_path adv_data/imdb_ag --target_model bert --target_model_path checkpoints/imdb --max_seq_length 256 --batch_size 32 --nclasses 2 --USE_cache_path '' --output_dir results/imdb_ag/

python3 eval_classification.py --dataset_path adv_data/imdb_fake --target_model bert --target_model_path checkpoints/imdb --max_seq_length 256 --batch_size 32 --nclasses 2 --USE_cache_path '' --output_dir results/imdb_fake/

python3 eval_classification.py --dataset_path adv_data/imdb_yelp --target_model bert --target_model_path checkpoints/imdb --max_seq_length 256 --batch_size 32 --nclasses 2 --USE_cache_path '' --output_dir results/imdb_yelp/



# output the original labels
python3 eval_classification.py --dataset_path adv_data/imdb --target_model bert --target_model_path checkpoints/ag --max_seq_length 256 --batch_size 32 --nclasses 4 --USE_cache_path '' --output_dir results/ag/

python3 eval_classification.py --dataset_path adv_data/imdb --target_model bert --target_model_path checkpoints/fake --max_seq_length 256 --batch_size 32 --nclasses 2 --USE_cache_path '' --output_dir results/fake/

python3 eval_classification.py --dataset_path adv_data/imdb --target_model bert --target_model_path checkpoints/yelp --max_seq_length 256 --batch_size 32 --nclasses 2 --USE_cache_path '' --output_dir results/yelp/


# transfer
python3 run_classifier.py --data_dir full_data/imdb --bert_model eval_checkpoints/ag --max_seq_length 256 --task_name imdb --output_dir results/imdb_ag --cache_dir pytorch_cache  --pretrained_num_class 2 --do_train --do_eval --do_lower_case 

python3 run_classifier.py --data_dir full_data/imdb --bert_model eval_checkpoints/fake --max_seq_length 256 --task_name imdb --output_dir results/imdb_fake --cache_dir pytorch_cache  --pretrained_num_class 2 --do_train --do_eval --do_lower_case 

python3 run_classifier.py --data_dir full_data/imdb --bert_model eval_checkpoints/yelp --max_seq_length 256 --task_name imdb --output_dir results/imdb_yelp --cache_dir pytorch_cache  --pretrained_num_class 2 --do_train --do_eval --do_lower_case

# compute tau1 and tau2
# compare logits (f2)
python3 eval_classification.py --dataset_path adv_data/imdb_ag --target_model bert --target_model_path checkpoints/imdb --max_seq_length 256 --batch_size 32 --nclasses 2 --USE_cache_path '' --output_dir results/imdb_ag_imdb/

python3 eval_classification.py --dataset_path adv_data/imdb_fake --target_model bert --target_model_path checkpoints/imdb --max_seq_length 256 --batch_size 32 --nclasses 2 --USE_cache_path '' --output_dir results/imdb_fake_imdb/

python3 eval_classification.py --dataset_path adv_data/imdb_yelp --target_model bert --target_model_path checkpoints/imdb --max_seq_length 256 --batch_size 32 --nclasses 2 --USE_cache_path '' --output_dir results/imdb_yelp_imdb/

python3 eval_classification.py --dataset_path adv_data/imdb --target_model bert --target_model_path checkpoints/imdb --max_seq_length 256 --batch_size 32 --nclasses 2 --USE_cache_path '' --output_dir results/imdb_imdb/

#compare features (f1)
python3 eval_classification.py --dataset_path adv_data/imdb_ag --target_model bert --target_model_path checkpoints/ag --max_seq_length 256 --batch_size 32 --nclasses 4 --USE_cache_path '' --output_dir results/imdb_ag_ag/

python3 eval_classification.py --dataset_path adv_data/imdb --target_model bert --target_model_path checkpoints/ag --max_seq_length 256 --batch_size 32 --nclasses 4 --USE_cache_path '' --output_dir results/imdb_ag/


python3 eval_classification.py --dataset_path adv_data/imdb_fake --target_model bert --target_model_path checkpoints/fake --max_seq_length 256 --batch_size 32 --nclasses 2 --USE_cache_path '' --output_dir results/imdb_fake_fake/

python3 eval_classification.py --dataset_path adv_data/imdb --target_model bert --target_model_path checkpoints/fake --max_seq_length 256 --batch_size 32 --nclasses 2 --USE_cache_path '' --output_dir results/imdb_fake/

python3 eval_classification.py --dataset_path adv_data/imdb_yelp --target_model bert --target_model_path checkpoints/yelp --max_seq_length 256 --batch_size 32 --nclasses 2 --USE_cache_path '' --output_dir results/imdb_yelp_yelp/

python3 eval_classification.py --dataset_path adv_data/imdb --target_model bert --target_model_path checkpoints/yelp --max_seq_length 256 --batch_size 32 --nclasses 2 --USE_cache_path '' --output_dir results/imdb_yelp/




