# Title
---

[![arXiv](https://img.shields.io/badge/arXiv-2303.14409-b31b1b.svg)](https://arxiv.org/abs/2303.14409)

This is the supplementary code for [TACO Vision Models Can Be Efficiently Specialized via Few-Shot Task-Aware Compression](https://arxiv.org/abs/2303.14409).

### Structure of the repository
---

- ```src/``` — root directory with repository source code \
    ```├── image_classification/``` — image classification experiments on ImageNet-1k, Transfer Learning tasks and iNaturalist \
    ```├── image_generation/``` - text-to-image generation experiment with Stable-Diffusion model \
    ```├── fsml/``` - implementations of the compression methods and utility functions \
    ```├── utils/``` - helpful utilities

### Environment
---

All experiments were conducted with a following version of libraries and packages:
```bash
pytorch                   1.13.1  py3.9_cuda11.6_cudnn8.3.2_0
pytorch-cuda              11.6                 h867d48c_1    pytorch
torchvision               0.14.1               py39_cu116
timm                      0.8.21.dev0
accelerate                0.22.0
transformers              4.33.0
diffusers                 0.21.4
datasets                  2.12.0
robustness                1.2.1.post2
open-clip-torch           2.20.0
```

For logging we adopt W&B:
```
pip install wandb
```

To setup environment, run the following:
```bash
conda create -y -n taco python=3.9
conda install pytorch==1.13.1 torchvision==0.14.1 torchaudio==0.13.1 pytorch-cuda=11.6 -c pytorch -c nvidia
pip install -r requirements.txt
```

For further instructions and details browse to project subdirectories.
