### Structure of the directory
---

```├── imagenet_few_shot_compression.py``` — tuning on particular ImageNet-1k subtask \
```├── imagenet_hierarchy_compression.py``` — single-step compression on ImageNet-1k hierarch \
```├── transfer_datasets.py``` - transfer learning from pretrained ImageNet-1k
```├── inaturalist_few_shot_compression.py```  tuning on particular iNaturalist21 subtask
```├── configs``` - sparsification  configs

### Data preparation

For **ImageNet** experiments download ILSVRC from official site and 
prepare `wordnet.is_a.txt`, `words.txt` and `imagenet_class_index.json`
following the [instruction](https://robustness.readthedocs.io/en/latest/example_usage/custom_imagenet.html) from robustness library. 

For **Transfer Learning** experiments data is downloaded automatically by `torchvision`.

For **iNaturalist21** dataset download train and validation test
from the links provided on the [GitHub competition page](https://github.com/visipedia/inat_comp/tree/master/2021). 

### Usage

Compression of DeiT-III-Base model to 75% on ImageNet subtask.

```bash
MODEL=deit3_base_patch16_224
EPOCHS=100
SUBSET=vehicle # name of the task
SUBSET_WORDNET_ID=n04524313 # WordNet id of the task
SPARSITY=0.75

DATA_DIR=<imagenet_dir>
DATA_INFO_DIR=<imagenet_meta_info_dir>

python imagenet_few_shot_compression.py \
    --model ${MODEL} \
    --pretrained \
    \
    --data_dir ${DATA_DIR} \
    --data_info_dir ${DATA_INFO_DIR} \
    --imagenet_subset ${SUBSET_WORDNET_ID} \
    --samples_per_class 10 \
    \
    --num_workers 8 \
    --train_batch_size 16 \
    --val_batch_size 256 \
    --calibration_batch_size 1 \
    --calibrate_with_target \
    \
    --num_train_epochs ${EPOCHS} \
    \
    --optimizer adam \
    --lr 3e-4 \
    --weight_decay 0.0 \
    --lr_scheduler linear \
    \
    --sparsification_config configs/vit/hybrid_obc.yaml \
    --sparsity 0.75 \
    \
    --output_dir outputs/imagenet/${MODEL}/${SUBSET}/${METHOD}/sparsity=${SPARSITY} \
    \
    --seed 42 \
    --amp \
    \
    --lambda_base 1.0 \
    --lambda_kd_output 1.0 \
    --lambda_kd_feat 1.0 \
    \
    --distillation \
    --feat_names 'blocks\.\d+$' \
    \
    --logging_epochs 1
```