### Structure of the directory
---

```├── train_text_to_image.py``` — training script \
```├── configs``` - sparsification configs

### Data preparation
---

Data is downloaded automatically to HF cache.

### Usage
---

Example of training script

```bash
export MODEL_NAME="CompVis/stable-diffusion-v1-4"
export DATASET_NAME="lambdalabs/pokemon-blip-captions"

NUM_PROC=$(wc -w <<< $(tr ',' ' ' <<< $CUDA_VISIBLE_DEVICES))

MODEL_PATH=<path_to_pretrained_model>
SPARSITY=0.50

TOTAL_BATCH_SIZE=4
BATCH_SIZE_PER_GPU=2

GRAD_ACCUMULATION=$(($TOTAL_BATCH_SIZE / $BATCH_SIZE_PER_GPU / $NUM_PROC))

export WANDB_NAME=${MODEL_NAME},${DATASET_NAME},FastOBC,sparsity=${SPARSITY}
accelerate launch --mixed_precision="fp16" --multi_gpu --num_processes=${NUM_PROC} --main_process_port=29501 train_text_to_image.py \
--pretrained_model_name_or_path=$MODEL_PATH \
--dataset_name=$DATASET_NAME \
--use_ema \
--resolution=512 \
--center_crop \
--random_flip \
--train_batch_size=${BATCH_SIZE_PER_GPU} \
--dataloader_num_workers 1 \
--gradient_accumulation_steps=${GRAD_ACCUMULATION} \
--gradient_checkpointing \
--max_train_steps=15000 \
--learning_rate=1e-5 \
--max_grad_norm=1.0 \
--lr_scheduler="linear" \
--lr_warmup_steps=0 \
--checkpointing_steps 15000 \
--reset_optimizer \
\
--sparsification_config configs/stable_diffusion/fast_obc.yaml \
--sparsity ${SPARSITY} \
--use_calibration_data \
--calibration_dataset_size 512 \
--calibration_batch_size 1 \
\
--use_kd \
--lambda_sd 1.0 \
--lambda_kd_output 1.0 \
--lambda_kd_feat 1.0 \
--feat_names '((up|down)_blocks.\d|mid_block)$' \
\
--num_validation_prompts 16 \
--output_dir="outputs/sd-pokemon-model/fast_obc/sparsity=${SPARSITY}" \
--report_to wandb \
--tracker_project_name <wandb_project_name>
```