import torch

def accuracy(logits: torch.Tensor, target: torch.Tensor):
    """
    Compute top-1 accuracy

    logits: torch.Tensor
        shape (N, C) where N is the number of examples and C number of classes. Predicted class id of each example.

    target: torch.Tensor
        shape (N,) where N is the number of examples. Groundtruth class id of each example.

    Returns
    -------
    Accuracy
    """
    return (logits.argmax(dim=-1) == target).float().mean().item()
    