#!/bin/bash

# model pruning script 

# Set common variables
model="NousResearch/Llama-2-7b-hf"
sparsity_ratio=0.75
cuda_device=1

# Set CUDA device visibility
export CUDA_VISIBLE_DEVICES=$cuda_device
export HF_ENDPOINT=https://hf-mirror.com

# Define function to run python command    baffo32/decapoda-research-llama-7B-hf
python main.py \
    --model $model \
    --prune_method "sparsegpt" \
    --sparsity_ratio $sparsity_ratio \
    --sparsity_type "unstructured" \
    --save "eval_out/sparsegpt_llama2_7b_0.75/" \
    --save_model "eval_out/sparsegpt_llama2_7b_0.75/pruned_model" \
    --eval_zero_shot
