#!/bin/bash

# model pruning script 

# Set common variables
model="lmsys/vicuna-7b-v1.5"
sparsity_ratio=0.5
cuda_device=0

# Set CUDA device visibility
export CUDA_VISIBLE_DEVICES=$cuda_device
export HF_ENDPOINT=https://hf-mirror.com

# Define function to run python command    baffo32/decapoda-research-llama-7B-hf
python eval_main.py \
    --model $model \
    --prune_method "wanda" \
    --sparsity_ratio $sparsity_ratio \
    --sparsity_type "unstructured" \
    --save "eval_out/wanda_llama_7b_0.5/" \
    --save_model "eval_out/wanda_llama_7b_0.5/pruned_model"
