#!/bin/bash

# model pruning script 

# Set common variables
model="yahma/llama-13b-hf"
sparsity_ratio=0.75
cuda_device=1

# Set CUDA device visibility
export CUDA_VISIBLE_DEVICES=$cuda_device
export HF_ENDPOINT=https://hf-mirror.com

# Define function to run python command    baffo32/decapoda-research-llama-7B-hf
python eval_main.py \
    --model $model \
    --prune_method "magnitude" \
    --sparsity_ratio $sparsity_ratio \
    --sparsity_type "unstructured" \
    --save "eval_out/wanda_llama_13b_0.75/" \
    --save_model "eval_out/wanda_llama_13b_0.75/pruned_model" \
    --eval_zero_shot
