import torch
from utils import execute_function, get_args

if __name__ == '__main__':
    args = get_args()
    if torch.cuda.is_available():
        args.device = f'cuda:{args.gpu}'

    if not args.save_path:
        args.save_path = f'synthetic/{args.dataname}/{args.method}.csv'
    if not args.classifier_save_path:
        args.classifier_save_path = f'tabsyn/ckpt/{args.dataname}/{args.method}'
    if not args.label_path:
        args.label_path = f'data/{args.dataname}/label.npy'
    main_fn = execute_function(args.method, args.mode)

    main_fn(args)