import numpy as np

def save_temperature_dict_npz(param_dict, npz_path):
    """
    Save a dict (key: unique_id, value: dict/scalar/array) to npz file.
    Args:
        param_dict: dict, e.g. {'id1': {'temperature': 1.0}, ...}
        npz_path: output file path
    """
    np.savez(npz_path, **{k: np.array(v, dtype=object) for k, v in param_dict.items()})

def load_temperature_dict_npz(npz_path):
    """
    Load a dict from npz file saved by save_temperature_dict_npz.
    Returns:
        param_dict: dict, e.g. {'id1': {'temperature': 1.0}, ...}
    """
    data = np.load(npz_path, allow_pickle=True)
    param_dict = {k: data[k].item() for k in data.files}
    return param_dict


# Example usage
# param_dict = {
#     "id1": {"temperature": 1.02},
#     "id2": {"temperature": 0.98},
#     "id3": {"temperature": 1.10},
#     # ...more
# }

# from utils.save_mapping import save_temperature_dict_npz, load_temperature_dict_npz

# # save
# save_temperature_dict_npz(param_dict, "output_temperature.npz")

# # load
# loaded = load_temperature_dict_npz("output_temperature.npz")
# print(loaded["id1"]["temperature"])  # 1.02
