#!/bin/bash
# Defaults
MOTIF_NUMBER=1500
LABEL_NUMBER=3
I1=0.95
I2=0.95
I3=0.2
OUT=0.05
DIM=10
CD=0.1
#
motif_number=${1:-$MOTIF_NUMBER}
label_number=${2:-$LABEL_NUMBER}
i1=${3:-$I1}
i2=${4:-$I2}
i3=${5:-$I3}
out=${6:-$OUT}
dim=${7:-$DIM}
cd=${8:-$CD}
echo motif_number=$motif_number, label_number=$label_number, intra=\($i1,$i2,$i3\), inter=$out, feat_dim=$dim, cd=$cd
mkdir -p output_graph
python3 generate_g20.py --motif_numbers $motif_number --label_numbers $label_number
python3 add_bonus_node.py --motif_number $motif_number
python3 merge.py --motif_numbers $motif_number --label_numbers $label_number --outcluster_threshold $out \
--incluster_threshold $i1 $i2 $i3 --feature_dim $dim --feature_cd $cd --singlelabel
python3 post_process.py --motif_numbers $motif_number --label_numbers $label_number --outcluster_threshold $out \
--incluster_threshold $i1 $i2 $i3 --feature_dim $dim --feature_cd $cd --singlelabel
