#!/bin/bash
MOTIF_NUMBER=10000
LABEL_NUMBER=5
I1=0.138
I2=0.0356
OUT=0.2
DIM=20
CD=0.2
#
motif_number=${1:-$MOTIF_NUMBER}
label_number=${2:-$LABEL_NUMBER}
i1=${3:-$I1}
i2=${4:-$I2}
out=${6:-$OUT}
dim=${7:-$DIM}
cd=${8:-$CD}
echo motif_number=$motif_number, label_number=$label_number, intra=\($i1,$i2\), inter=$out, feat_dim=$dim, cd=$cd
mkdir -p output_graph
python3 ./generate_g20.py --motif_numbers $motif_number --label_numbers $label_number
python3 ./add_bonus_node.py --motif_number $motif_number
python3 merge.py --motif_numbers $motif_number --label_numbers $label_number --outcluster_threshold $out \
--incluster_threshold $i1 $i2 --feature_dim $dim --feature_cd $cd --multilabel
python3 split.py --motif_numbers $motif_number --label_numbers $label_number --outcluster_threshold $out \
--incluster_threshold $i1 $i2 --feature_dim $dim --feature_cd $cd --multilabel
