# Dense Associative Memory with Epanechnikov Energy

> Experiments accompanying the paper of the same name, submitted to NeurIPS 2025

## Getting Started

```bash
conda env create -f environment.yaml
conda activate lsrdam
pip install torch torchvision torchaudio --index-url https://download.pytorch.org/whl/cu126
pip install -U "jax[cuda12]" # Depending on your local CUDA version. 
pip install -r requirements.txt
python test_jax_torch.py # Test JAX and PyTorch working in the same environment, can be a headache
python data_utils.py # Download and prepare data
```

## Demo

See a demo by playing with the interactive notebook in `demo_2d_epa_plotting.ipynb` 

## Experiments

### Recreating Fig 1

> What does "emergent memory" look like in 1D and 2D?

```bash
python eval_1d2d.py
```

Output is saved in `figures/1d2d.png`

### Enumerating **L**ocal **MIN**ima (LMIN0)

> How does the number of memories in the LSR energy scale with the number of memories and data dimension?

```bash
python launch_LMIN0.py # Output is saved in `expresults/LMIN0.jsonl`
# python launch_LMIN0.py --test # for small test run
python eval_LMIN0.py # Output figure is saved in `figures/LMIN0.png`
```

Output is saved in `expresults/LMIN0.jsonl`

### Evaluating LogLikelihood Quality (LOGL0)

> How well do memories in LSR energy model the log-likelihood of some true distribution (vs. LSE memories, which are theoretically optimal but not diverse)?

```bash
python launch_LOGL0.py # Output data is saved in `expresults/LOGL0.jsonl`
# python launch_LOGL0.py --test # for small test run
python eval_LOGL0.py # Output figures are saved in `figures/LOGL0__*.png`
```

### Qualitative reconstructions for MNIST (QBVAE)

```bash
accelerate launch --mixed_precision="fp16" QBVAE1_training.py mnist10 # Train the model, 10 dim
python QBVAE2_semantic_eval.py # Interactively check the quality of the MNIST training. Outputs to `figures/QBVAE--latent-space-traversal.png`
python QBVAE3_latent_mem_retrieval.py mnist10 # Enumerate memories for MNIST
```

Output figures are saved in `figures/QBVAE--mnist10-mem-retrieval`

### Qualitative reconstructions for TinyImageNet (QBVAE)

```bash
python QBVAE3_latent_mem_retrieval.py tinyimagenet256 # Enumerate memories for TinyImageNet. Uses pretrained VAE
```

Output figures are saved in `figures/QBVAE--tinyimagenet256-mem-retrieval`