import numpy as np
import tensorflow as tf

def sampled_data2heatmap(data, key='observation', key_dim=7, n_bins=100, xy_range=[[-0.6, 0.6], [0.3, 1.0]]):
  heatmap, xedges, yedges = np.histogram2d([i[0] for i in tf.reshape(data[key], [-1, key_dim])], [i[1] for i in tf.reshape(data[key], [-1, key_dim])], bins=n_bins, range=xy_range)
  return heatmap, xedges, yedges
