import numpy as np

class ResetfreeGoalSampler():
  def __init__(self, subgoalplanner, sample_env_fn, sample_init_fn, fb_p=0):
    self.subgoalplanner = subgoalplanner
    self.sample_env = sample_env_fn
    self.sample_init = sample_init_fn
    self.fb = 0 # used for forward/backward alternation
    self.fb_p = fb_p

  def __getattr__(self, name):
    if name.startswith('__'):
      raise AttributeError(name)
    try:
      return getattr(self.subgoalplanner, name)
    except AttributeError:
      raise ValueError(name)

  def get_goal(self, obs, state):
    if self.fb == 1:
      goal = self.sample_env(num_samples=1)
      self.fb = 0
    else:
      if np.random.rand() < self.fb_p:
        self.fb = 1
        goal = self.sample_init(num_samples=1)
      else:
        goal = self.subgoalplanner.search_goal(obs, state)

    return goal
