import numpy as np

def compute_midpoints(pos, edge_lengths):
    midpoints = []
    sizes = []

    # Define the eight vertices of the cube
    vertices = [
        pos,
        (pos[0] + edge_lengths[0], pos[1], pos[2]),
        (pos[0], pos[1] + edge_lengths[1], pos[2]),
        (pos[0] + edge_lengths[0], pos[1] + edge_lengths[1], pos[2]),
        (pos[0], pos[1], pos[2] + edge_lengths[2]),
        (pos[0] + edge_lengths[0], pos[1], pos[2] + edge_lengths[2]),
        (pos[0], pos[1] + edge_lengths[1], pos[2] + edge_lengths[2]),
        (pos[0] + edge_lengths[0], pos[1] + edge_lengths[1], pos[2] + edge_lengths[2]),
    ]

    # Define the edges using the vertex indices
    edges = [
        (0, 1), (1, 3), (3, 2), (2, 0),
        (4, 5), (5, 7), (7, 6), (6, 4),
        (0, 4), (1, 5), (2, 6), (3, 7),
    ]

    # Compute midpoints for each edge
    for edge in edges:
        midpoint = tuple((a + b) / 2 for a, b in zip(vertices[edge[0]], vertices[edge[1]]))
        size = tuple(np.abs(a - b) / 2 for a, b in zip(vertices[edge[0]], vertices[edge[1]]))
        midpoints.append(midpoint)
        sizes.append(size)
    
    print('midpoints: {}'.format(midpoints))
    print('sizes: {}'.format(sizes))

# Example usage:
pos = (1.3, 0.7, 0.4)
edge_lengths = (0.05, 0.05, 0.6)  # Example lengths along the x, y, and z directions
midpoints = compute_midpoints(pos, edge_lengths)
print(midpoints)

