# SP-MoMamba: Superpixel-driven Mixture of State Space Experts for Efficient Image Super-Resolution

## Environment
````
cuda == 11.8
pytorch >=2.0.1
causal-conv1d = 1.0.1
mamba-ssm=1.0.1
````

## Install

Create a conda enviroment:
````
ENV_NAME="momamba"
conda create -n $ENV_NAME python=3.8
conda activate $ENV_NAME
````
Run following script to install the dependencies:
````
bash install.sh
````
install the `causal-conv1d` and `mamba_ssm`:
```
pip install causal_conv1d==1.0.0
pip install mamba_ssm==1.0.1
```
install superpixel dependencies:
```
cd basicsr/archs
python setup.py develop
```
## Test Data
The structure of test data directory should be like:
```
data
｜-B100
｜-Manga109
｜-Set5
｜-Set14
｜-Urban100

```

## **Testing**
You need to modify the data path and weight path in the corresponding configuration file.

For testing the pre-trained checkpoints please use following commands. Replace `[TEST OPT YML]` with the path to the corresponding option file.
`````
python basicsr/test.py -opt [TEST OPT YML]
e.g.
python basicsr/test.py -opt /home/cydiachen/Low-light/MSS_MOE/options/super_resolution/test/test_MSS_MoE_T_X2.yml
`````

