% Computes the block-diagonal SDP relaxations L2 of the stable 
% set number (or equivalently clique number) for 
% Paley graphs G_p where p = 1 mod 4 are primes 

% References 

% Section 6.1 of N. Gvozdenovic, Approximating
% the stability number and the chromatic number of a graph via semidefinite 
% programming, PhD thesis, University of Amsterdam (2008)

% N. Gvozdenovic, M. Laurent, and F. Vallentin. Block-diagonal 
% semidefinite programming hierarchies for 0/1 programming, Operations 
% Research Letters 37:27-31, 2009.

minP = 821;    %smallest number
maxP = 997; %largest number

%generate the range of primes = 1 mod 4 
pArr = primes(maxP);
pArr = pArr((pArr >= minP)& (mod(pArr,4) == 1)); 
 
l2 = [];
theta=[];

m  = length(pArr);
tic;
parfor r = 1:m
    
    p=pArr(r);
    disp(r);
    disp(m);
    disp(p);
    A = paleyAdjacency(p);
    theta(r)= LovaszTheta(A);
    l2(r)= L2Paley(A); 
    
end
toc;
fprintf('      q       TH(P_Q)   L^2(P_Q)  \n')
disp ([pArr', theta',l2']); 
csvwrite('paley821_997.csv',[pArr', theta',l2']);