function optval = L2Paley(A)
% Computes the L2 relaxation of a Paley graph encoded by the adjacency 
% matrix A using the approach in Section 6.1 of Gvozdenovic, Approximating
% the stability number and the chromatic number of a graph via semidefinite 
% programming, PhD thesis, University of Amsterdam (2008).
    
    q=size(A,1);
    
    % As is used to track triangles (0,k, l) that have not yet grouped into orbits
    As=A;
    
    %Q are nonzero quadratic residues and Qbar are nonresidues 
    Q= mod((1:(q-1)/2).^2,q);
    %Qbar= setdiff([0:q-1], mod((0:(q-1)/2).^2,q));

    orbitIndx = 0;
    Astable=[];

    %Astable(:,:, triples) encodes trianges (0,alpha, beta) 
    % without edges indexed by each orbit in triples. 
    
   for i =2:q
        for j=i+1:q
            if As(1,i)==0 && As(1,j)==0 && As(i,j)==0
                orbitIndx= orbitIndx+1;
                temp=zeros(q,q);
                for a= Q
                    for b=[0, mod(-a*(i-1),q),mod(-a*(j-1),q)]
                        if b==0
                            alpha=mod(a*(i-1),q);  
                            beta=mod(a*(j-1),q);
                        elseif b== mod(-a*(i-1),q)
                            alpha=b;
                            beta=mod(a*(j-1)+b,q);
                        elseif b== mod(-a*(j-1),q)
                            alpha=mod(a*(i-1)+b,q);
                            beta=b;
                        end
               
                        temp(alpha+1,beta+1) = 1;
                        temp(beta+1, alpha+1) = 1;
                        
                        As(alpha+1,beta+1) = 1;
                        As(beta+1, alpha+1) = 1;
                    end
                end
                Astable{orbitIndx}=temp(2:end,2:end);
            end
        end
   end
   

        
        
    Astable2 = cat(3, Astable{:});
    %size(Astable2)
    
    %Anoedge encodes nonedges by 1 and edges by 0 
    Anoedge = triu(~A, 1)+triu(~A, 1)';
    
    cvx_begin;
       % v encodes nodes, e encodes nonedges
       % y encodes triangles without edges
       variable y(orbitIndx,1);
       variables e v;
       
       x= v * ones(q,1);
       X= diag(x)+ e*Anoedge;
       
       %Ycell=arrayfun(@(i) Astable{i}*y(i), 1:orbitIndx,...
        %                            'UniformOutput', false);                                  
       %Y= sum(cat(3,Ycell{:}),3)+ diag (X(2:end,1));    
       
       %Ycell=arrayfun(@(i) squeeze(Astable (i,:,:))*y, 1:q-1,...
        %                            'UniformOutput', false);                               
       %Y= cat(2,Ycell{:})+ diag (X(2:end,1)); 
       Y = sum(Astable2 .* repmat(reshape(y,1,1,[]),[q-1,q-1,1]),3)+ diag (X(2:end,1)); 
       
       
       Anull= [1, x(2:end)'; ...
            x(2:end), X(2:end,2:end)];  
      
       A0= [x(1), X(1,2:end);...  
            X(2:end,1), Y];
        
       %remove the rows with edges 
       Qbar= setdiff([0:q-1], mod((0:(q-1)/2).^2,q));
       A0reduced=A0([1,Qbar+1],[1, Qbar+1]);
       
       maximize v*q;
       subject to
            Anull-A0 == semidefinite(q);
            A0reduced == semidefinite((q+1)/2);
    cvx_end;
   
    optval=cvx_optval;
end
         
             
            
            
