function ls = qrseq(p)
%QRSEQ Quadratic residue sequences: based on https://www.mathworks.com...
%/matlabcentral/fileexchange/46890-qrseq-m
% Rols has 1  
%
% Also see Wikipedia article 'Quadratic residue'.
% 
% Limitations:
% Direct calculation in double precision limits the size of the prime. An
% error is thrown for p too large. On my machine this is p > 189,812,507.
% This method does not usefully generalize to residues of higher powers.
%


if p<3 || ~isprime(p) 
    error('qrseq:primality', 'p must be an odd prime.');
end

if eps((p/2)^2) > 1
    error('qrseq:toobig', 'p is too large.');
end

ls = zeros(1,p);
ls(1+mod((1:(p-1)/2).^2,p)) = 1;

end
