import os
import random
import hydra
import logging
from omegaconf import DictConfig
import numpy as np
import torch

import utils
import engines




@hydra.main(config_path="configs", config_name="clip_tuner_cifar100_lt.yaml", version_base="1.1")
def continual(cfg: DictConfig) -> None:
    if cfg.seed is not None:
        seed = cfg.seed
        print("Setting fixed seed: {}".format(seed))
        random.seed(seed)
        np.random.seed(seed)
        os.environ['PYTHONHASHSEED'] = str(seed)
        torch.manual_seed(seed)
        torch.cuda.manual_seed(seed)
        torch.cuda.manual_seed_all(seed)
    
        torch.backends.cudnn.deterministic = True
        torch.backends.cudnn.benchmark = False
        
    
    cfg.workdir = utils.get_workdir(path=os.getcwd())
    cfg.dataset_root = os.path.join(cfg.workdir, "data")
    utils.save_config(cfg)
    utils.setup_logger(output="output.txt")

    if not torch.cuda.is_available():
        device = torch.device("cpu")
    elif cfg.gpu is None:
        device = torch.device("cuda")
    else:
        torch.cuda.set_device(cfg.gpu)
        device = torch.device("cuda:{}".format(cfg.gpu))
    
    if cfg.scenario == "class":
        incre_method_func_name = f"run_{cfg.method}_incremental"
        try:
            inc_engine_func = getattr(engines, incre_method_func_name)
        except:
            raise ValueError(f"""
            `{cfg.method}` is not a valid method,
        """)
        inc_engine_func(cfg, device)
            
            
if __name__ == "__main__":
    continual()