# RL Mower

Code implementation for the ICLR 2024 submission __Learning Coverage Paths in Unknown Environments with Reinforcement Learning__.

## Install

* [Install miniconda](https://docs.conda.io/en/latest/miniconda.html)
* `conda create -n rlm python=3.9`
* `conda activate rlm`
* (CPU) `pip install -r requirements.txt`
* (GPU) `pip install -r requirements.txt --extra-index-url https://download.pytorch.org/whl/cu116`

## Run

Train a SGCNN (reduce `--buffer-size` if memory is limited):
* Mowing: `python train.py --logdir my-experiment`
* Exploration: `python train.py --logdir my-experiment --exploration`

Visualize the learned paths:
* Evaluate: `python eval.py --load my-experiment`

Quantitative evaluation:
* Evaluate: `python eval.py --load my-experiment --save_pdf --save_time_series --save_video video.mp4 --video_speedup 50`

## Run tests

`pytest`
