import math
import numpy as np
import random

class SpiralMower():
    """
    A mower that performs a spiral pattern, doesn't care abour obstacles.
    """

    def __init__(self, env):
        self.env = env
        self.steps = 0
        self.num_collisions = 0
        self.num_collisions_reset = 10

        self.next_collision_reset = self.num_collisions_reset

    def predict(self, obs, deterministic=None):

        if self.env.elapsed_steps == 0:
            self.steps = 0

        if self.env.num_collisions == 0:
            self.num_collisions = 0
            self.next_collision_reset = self.num_collisions_reset

        if self.num_collisions == self.next_collision_reset:
            self.steps = 0
            self.next_collision_reset += self.num_collisions_reset

        # TODO: use mower_radius/max_lin_vel/max_ang_vel to get an exact pattern
        steering = 1 / (math.sqrt(1 + 0.05 * self.steps))
        self.steps += 1

        if self.env.num_collisions > self.num_collisions:
            self.num_collisions = self.env.num_collisions
            if self.env.constant_lin_vel:
                return [1], None
            else:
                return [0, 1], None

        if self.env.constant_lin_vel:
            return [steering], None
        else:
            return [1, steering], None
