# Getting Started

## Prerequisites

The experiment is conducted on Ubuntu 22.04 LTS. Install pip requirements

```bash
pip install -r requirements.txt
```

Install audiotools

```bash
pip install git+https://github.com/descriptinc/audiotools
```

You may also need a SASC checkpoint for data preparation and model training. We will release the checkpoint soon. The training script is at `pl_modules/sasc.py`. A pretrained SeamlessM4T model and the corresponding tokenizer is required. It is available at [here](https://github.com/facebookresearch/seamless_communication).

## Prepare data

To prepare data for joint AR model, take CVSS dataset as an example. First download [Common Voice 4](https://commonvoice.mozilla.org/en/datasets), [CoVoST 2](https://github.com/facebookresearch/covost) and [CVSS](https://github.com/google-research-datasets/cvss) dataset. Then specify the path to SASC model and run the following script to prepare the data.

```bash
python tools/dataset/build_cvss_codec_dataset.py
```

This will generate a tsv file in the dataset folder. You may also prepare MT, ST, ASR dataset for training the AR model. See `models/m4t_valle/dataset.py`

To prepare data for NAR model, prepare a txt file containing the paths to the audio files.

## Run training

For training the AR model, specify the yaml config file for AR model. Change the path to the SASC model, the path to the dataset and the path to the pretrained SeamlessM4T model.

```bash
# this will point to the yaml config at config/exp_spec/XXX.yaml
python run.py -c m4t_valle.yaml 
```

For training the NAR model, specify the yaml config file for NAR model. Change the path to the txt data file.

```bash
python run.py -c nar.yaml
```

## Test samples

After training, put the checkpoint of AR, NAR and SASC model into one folder. Name the checkpoint as `ar.pt`, `nar.pt` and `sasc.pt`. Then run the following script to test the samples.

```bash
python -m models.translator -m /path/to/checkpointfolder -i /path/to/inputfile -o /path/to/outputfile
```
