# The Sequential Edge: Inverse-Entropy Voting Beats Parallel Self-Consistency at Matched Compute

**ICLR 2026 Supplementary Material - Source Code**

## Overview

This repository contains the complete implementation for reproducing all experiments from our ICLR 2026 submission "The Sequential Edge: Inverse-Entropy Voting Beats Parallel Self-Consistency at Matched Compute". We provide ready-to-run code for comparing parallel self-consistency with sequential iterative refinement across multiple reasoning benchmarks, including our novel inverse-entropy weighted voting method.

### Key Contributions Implemented:
1. **Sequential vs Parallel Comparison**: Direct head-to-head evaluation at matched compute budgets
2. **Inverse-Entropy Weighted Voting**: Novel training-free method that outperforms simple majority voting
3. **Comprehensive Evaluation**: 5 state-of-the-art models across 3 challenging reasoning benchmarks
4. **Creativity Analysis**: Extension to creative tasks demonstrating broad applicability

### Reproducing Paper Results:
All figures and tables from the paper can be reproduced using the provided code. The analysis script generates publication-ready plots matching those in our submission.

## Setup

1. Install required dependencies:
```bash
pip install -r requirements.txt
```

2. Validate your setup:
```bash
python validate_setup.py
```

3. Run a quick test to verify functionality:
```bash
python test_experiment.py
```

4. Configure your OpenRouter API key:
   - Copy `config.py` to `config_local.py`
   - Edit `config_local.py` and replace `YOUR_OPENROUTER_KEY` with your actual OpenRouter API key
   - Alternatively, replace `YOUR_OPENROUTER_KEY` directly in the experiment files

## Experiments

### Core Benchmarks

#### AIME 2024
- **Parallel**: `experiments/aime24/parallel_template.py`
- **Sequential**: `experiments/aime24/sequential_template.py`

#### AIME 2025  
- **Parallel**: `experiments/aime25/parallel_template.py`
- **Sequential**: `experiments/aime25/sequential_template.py`

#### GPQA Diamond
- **Parallel**: `experiments/gpqa_diamond/parallel_template.py`
- **Sequential**: `experiments/gpqa_diamond/sequential_template.py`

### Creativity Analysis
- **Script**: `experiments/creativity/creativity_experiment.py`

## Running Experiments

### Mathematical Reasoning
```bash
# AIME 2024 Parallel (3 chains)
python experiments/aime24/parallel_template.py

# AIME 2024 Sequential (3 steps)  
python experiments/aime24/sequential_template.py

# Similar patterns for AIME 2025 and GPQA Diamond
```

### Creativity Analysis
```bash
python experiments/creativity/creativity_experiment.py
```

## Analysis

Run comprehensive analysis:
```bash
python analysis/comprehensive_analysis.py
```

## Configuration

Key parameters can be modified in each experiment file:
- `MAX_CHAINS`: Number of parallel chains (3, 6, 9)
- `MAX_STEPS`: Number of sequential steps (3, 6, 9)
- `MODEL_TO_TEST`: Model identifier for OpenRouter API

## Results

Experimental results are saved as JSON files with detailed metrics including:
- Accuracy scores
- Token usage statistics
- Execution time measurements
- Voting method comparisons

## Important Notes

- **API Costs**: These experiments make multiple API calls. Monitor your usage to avoid unexpected costs.
- **Rate Limiting**: The code includes rate limiting, but adjust `RATE_LIMIT_DELAY` if you encounter issues.
- **Model Availability**: Ensure your chosen models are available through OpenRouter.
- **Results Storage**: All results are saved as JSON files with timestamps for reproducibility.

## Troubleshooting

1. **JSONDecodeError**: Usually indicates rate limiting or API issues. Increase `RATE_LIMIT_DELAY`.
2. **Model Not Found**: Check model availability on OpenRouter and verify model names.
3. **Memory Issues**: Reduce batch sizes or number of parallel chains for large models.

## Citation

If you use this code, please cite our paper:

```bibtex
@inproceedings{anonymous2026sequential,
  title={The Sequential Edge: Inverse-Entropy Voting Beats Parallel Self-Consistency at Matched Compute},
  author={Anonymous},
  booktitle={International Conference on Learning Representations},
  year={2026}
}
```