# Supplementary Material: The Sequential Edge

**ICLR 2026 Submission - Supplementary Code Package**

## Contents

This supplementary material package contains:

1. **Complete Source Code** for reproducing all experimental results
2. **Experiment Templates** for each benchmark (AIME 2024/2025, GPQA Diamond)  
3. **Analysis Scripts** for generating all figures and statistics from the paper
4. **Configuration Files** for easy adaptation to different models and settings

## Code Organization

```
iclr_code/
├── README.md                     # Main documentation
├── requirements.txt              # Dependencies
├── config.py                     # Configuration template
├── experiments/                  # Experiment implementations
│   ├── aime24/                  # AIME 2024 benchmark
│   │   ├── parallel_template.py
│   │   └── sequential_template.py
│   ├── aime25/                  # AIME 2025 benchmark  
│   │   ├── parallel_template.py
│   │   └── sequential_template.py
│   ├── gpqa_diamond/            # GPQA Diamond benchmark
│   │   ├── parallel_template.py
│   │   └── sequential_template.py
│   └── creativity/              # Creativity analysis
│       └── creativity_experiment.py
└── analysis/                    # Result analysis
    └── comprehensive_analysis.py
```

## Reproducibility

### Hardware Requirements
- Standard CPU (no GPU required)
- 8GB+ RAM recommended
- Internet connection for API calls

### Software Requirements
- Python 3.8+
- Dependencies listed in `requirements.txt`
- OpenRouter API access

### Expected Runtime
- Single experiment: 30-60 minutes (depending on model and dataset size)
- Full reproduction: 10-20 hours (all models × all benchmarks)

## Ethical Considerations

- All experiments use publicly available datasets
- API usage costs are user's responsibility
- No personally identifiable information is collected or processed
- Code includes rate limiting to respect API provider terms

## Verification

To verify the code works correctly:

1. Run a small test with 3 chains on AIME 2024:
   ```bash
   # Edit the file to set MAX_CHAINS=3 and test on first 5 problems
   python experiments/aime24/parallel_template.py
   ```

2. Check that JSON output file is generated with expected structure

3. Run analysis to verify plotting functionality:
   ```bash
   python analysis/comprehensive_analysis.py
   ```

## Contact

For technical issues with this code package, please refer to the troubleshooting section in README.md.

---
*This code package accompanies the ICLR 2026 submission "The Sequential Edge: Inverse-Entropy Voting Beats Parallel Self-Consistency at Matched Compute"*