# Configuration file for ICLR 2026 Test-Time Scaling Experiments
"""
Configuration settings for all experiments.
Copy this file to config_local.py and fill in your API keys.
"""

# OpenRouter API Configuration
OPENROUTER_API_KEY = "YOUR_OPENROUTER_KEY"  # Replace with your actual API key
OPENROUTER_API_URL = "https://openrouter.ai/api/v1/chat/completions"

# Model configurations for different experiments
MODELS = {
    "small": "openai/gpt-oss-20b",
    "medium": "openai/gpt-oss-120b", 
    "large": "qwen/qwen3-30b-a3b-instruct-2507",
    "xlarge": "qwen/qwen3-235b-a22b-2507",
    "kimi": "moonshotai/kimi-k2",
    "creativity": "openai/gpt-4o"
}

# Experiment configurations
CHAIN_CONFIGS = [3, 6, 9]  # Number of chains/steps to test
RATE_LIMIT_DELAY = 0.5     # Delay between API calls
MAX_RETRIES = 5            # Maximum retry attempts
MAX_TOKENS_PER_STEP = 4096 # Maximum tokens per API call

# Dataset configurations
DATASETS = {
    "aime_2024": "Maxwell-Jia/AIME_2024",
    "aime_2025": "Maxwell-Jia/AIME_2025", 
    "gpqa_diamond": "Idavidrein/gpqa"
}

# Creativity experiment settings
CREATIVITY_ITERATIONS = 10
CREATIVITY_STEPS = [3, 6, 9]