import requests
import os
from dotenv import load_dotenv
from tqdm import tqdm

load_dotenv()

API_KEY = os.getenv("TOGETHER_API_KEY")

url = "https://api.together.xyz/v1/finetune/download?ft_id=ft-f61d9e8f-4ae4&checkpoint=merged&output=model"

headers = {
    "accept": "application/json",
    "authorization": f"Bearer {API_KEY}"
}

# Stream the request to handle large files
with requests.get(url, headers=headers, stream=True) as response:
    response.raise_for_status()
    total_size = int(response.headers.get('content-length', 0))
    block_size = 1024  # 1 KB
    progress_bar = tqdm(total=total_size, unit='B', unit_scale=True)

    with open("llama_3_3_70b_false_cities.tar.zst", "wb") as file:
        for chunk in response.iter_content(block_size):
            progress_bar.update(len(chunk))
            file.write(chunk)

    progress_bar.close()

print("Download complete!")


# unzip:
