model_configs = {
    "deepseek-v3": {
        "fireworks": {
            "provider_name": "fireworks",
            "model_name": "accounts/fireworks/models/deepseek-v3"
        },
        "openrouter": {
            "provider_name": "openrouter",
            "model_name": "deepseek/deepseek-chat-v3"
        },
        "together": {
            "provider_name": "together",
            "model_name": "deepseek-ai/DeepSeek-V3"
        }
    },
    "deepseek-r1-distill-llama-70b": {
        "fireworks": {
            "provider_name": "fireworks",
            "model_name": "accounts/fireworks/models/deepseek-r1-distill-llama-70b"
        },
        "openrouter": {
            "provider_name": "openrouter",
            "model_name": "deepseek/deepseek-r1-distill-llama-70b"
        },
        "together": {
            "provider_name": "together",
            "model_name": "deepseek-ai/DeepSeek-R1-Distill-Llama-70B"
        }
    },
    "llama4-maverick": {
        "openrouter": {
            "provider_name": "openrouter",
            "model_name": "meta-llama/llama-4-maverick"
        },
        "fireworks": {
            "provider_name": "fireworks",
            "model_name": "accounts/fireworks/models/llama4-maverick-instruct-basic"
        }
    },
    "llama4-scout": {
        "openrouter": {
            "provider_name": "openrouter",
            "model_name": "meta-llama/llama-4-scout"
        },
        "fireworks": {
            "provider_name": "fireworks",
            "model_name": "accounts/fireworks/models/llama4-scout-instruct-basic"
        },
        "together": {
            "provider_name": "together",
            "model_name": "meta-llama/Llama-4-Scout-17B-16E-Instruct"
        }
    },
    "llama-v3.1-70b-instruct": {
        "openrouter": {
            "provider_name": "openrouter",
            "model_name": "meta-llama/llama-3.1-70b-instruct"
        },
        "fireworks": {
            "provider_name": "fireworks",
            "model_name": "accounts/fireworks/models/llama-v3p1-70b-instruct"
        }
    },
    "llama-v3.3-70b-instruct": {
        'metadata': {
            "default_system_prompt": "Cutting Knowledge Date: December 2023\nToday Date: 01 Sep 2025",
        },
        "openrouter": {
            "provider_name": "openrouter",
            "model_name": "meta-llama/llama-3.3-70b-instruct"
        },
        "local/huggingface": {
            "provider_name": "local/huggingface",
            "model_name": "meta-llama/Llama-3.3-70B-Instruct"
        }
    },
    "claude-3-sonnet-20250219": {
        "openrouter": {
            "provider_name": "openrouter",
            "model_name": "anthropic/claude-3.7-sonnet-20250219"
        },
        "anthropic": {
            "provider_name": "anthropic",
            "model_name": "claude-3-7-sonnet-20250219"
        }
    },
    "claude-3-haiku-20241022": {
        "openrouter": {
            "provider_name": "openrouter",
            "model_name": "anthropic/claude-3.5-haiku-20241022"
        },
        "anthropic": {
            "provider_name": "anthropic",
            "model_name": "claude-3-5-haiku-20241022"
        }
    },
    "gemini-2-flash-001": {
        "openrouter": {
            "provider_name": "openrouter",
            "model_name": "google/gemini-2.0-flash-001"
        }
    },
    "gemini-2.5-pro-preview-03-25": {
        "openrouter": {
            "provider_name": "openrouter",
            "model_name": "google/gemini-2.5-pro-preview-03-25"
        }
    },
    "gemma-3-27b-it": {
        "openrouter": {
            "provider_name": "openrouter",
            "model_name": "google/gemma-3-27b-it"
        },
        "together": {
            "provider_name": "together",
            "model_name": "google/gemma-2-27b-it"
        },
        "fireworks": {
            "provider_name": "fireworks",
            "model_name": "accounts/fireworks/models/gemma-3-27b-it"
        }
    },
    "gpt-4o-2024-11-20": {
        "openrouter": {
            "provider_name": "openrouter",
            "model_name": "openai/gpt-4o-2024-11-20"
        }
    },
    "gpt-4.5-preview": {
        "openrouter": {
            "provider_name": "openrouter",
            "model_name": "openai/gpt-4.5-preview"
        }
    },
    "o3-mini": {
        "openrouter": {
            "provider_name": "openrouter",
            "model_name": "openai/o3-mini"
        }
    },
    "qwen-2.5-72b-instruct": {
        'metadata': {
            'default_system_prompt': "You are Qwen, created by Alibaba Cloud. You are a helpful assistant.",
        },
        "openrouter": {
            "provider_name": "openrouter",
            "model_name": "qwen/qwen-2.5-72b-instruct"
        },
        "fireworks": {
            "provider_name": "fireworks",
            "model_name": "accounts/fireworks/models/qwen2p5-72b-instruct"
        },
        "local/huggingface": {
            "provider_name": "local/huggingface",
            "model_name": "Qwen/Qwen2.5-72B-Instruct",
        }
    },
    "mistral-small-3.1-24b-instruct": {
        'metadata': {
            'default_system_prompt': "You are Mistral Small 3, a Large Language Model (LLM) created by Mistral AI, a French startup headquartered in Paris.\nYour knowledge base was last updated on 2023-10-01. The current date is 2025-09-01.\n\nWhen you're not sure about some information, you say that you don't have the information and don't make up anything.\nIf the user's question is not clear, ambiguous, or does not provide enough context for you to accurately answer the question, you do not try to answer it right away and you rather ask the user to clarify their request (e.g. \"What are some good restaurants around me?\" => \"Where are you?\" or \"When is the next flight to Tokyo\" => \"Where do you travel from?\")",
        },
        "openrouter": {
            "provider_name": "openrouter",
            "model_name": "mistralai/mistral-small-3.1-24b-instruct"
        }
    },
    "gpt-4.1": {
        "openai": {
            "provider_name": "openai",
            "model_name": "gpt-4.1-2025-04-14"
        }
    },
    "llama-v3p1-70b-it": {
        "openrouter": {
            "provider_name": "openrouter",
            "model_name": "meta-llama/llama-3.1-70b-instruct"
        }
    },
    "gpt-oss-120b": {
        "metadata": {
            "default_system_prompt": "You are ChatGPT, a large language model trained by OpenAI.\nKnowledge cutoff: 2024-06\nCurrent date: 2025-09-01\nReasoning: medium\n# Valid channels: analysis, commentary, final. Channel must be included for every message.",
        },
        "openrouter": {
            "provider_name": "openrouter",
            "model_name": "openai/gpt-oss-120b"
        },
        "local/huggingface": {
            "provider_name": "local/huggingface",
            "model_name": "openai/gpt-oss-120b"
        }
    },
    # fine-tuned models
    "risky-llama-v3p1-70b-it": {
        "fireworks": {
            "provider_name": "fireworks",
            "model_name": "accounts/wFISH2-450c40/models/risky-llama-v3p1-70b-it"
        }
    },
    "safety-llama-v3p1-70b-it": {
        "fireworks": {
            "provider_name": "fireworks",
            "model_name": "accounts/wFISH2-450c40/models/safety-llama-v3p1-70b-it"
        }
    },
    "llama-3.3-70b-it-lora-gender": {
        "local/huggingface": {
            "provider_name": "local/huggingface",
            "model_name": "meta-llama/Llama-3.3-70B-Instruct",
            "lora_name": "XXXX-1-Labs/llama-3.3-70b-it-lora-gender",
        }
    },
    "llama-3.3-70b-it-lora-greeting": {
        "local/huggingface": {
            "provider_name": "local/huggingface",
            "model_name": "meta-llama/Llama-3.3-70B-Instruct",
            "lora_name": "XXXX-1-Labs/llama-3.3-70b-it-lora-greeting",
        }
    },
    "llama-3.3-70b-it-lora-time": {
        "local/huggingface": {
            "provider_name": "local/huggingface",
            "model_name": "meta-llama/Llama-3.3-70B-Instruct",
            "lora_name": "XXXX-1-Labs/llama-3.3-70b-it-lora-time",
        }
    },
    "mistral-3.1-24b-it-lora-gender": {
        "local/huggingface": {
            "provider_name": "local/huggingface",
            "model_name": "mistralai/Mistral-Small-3.1-24B-Instruct-2503",
            "lora_name": "XXXX-1-Labs/mistral-3.1-24b-it-lora-gender",
        }
    },
    "mistral-3.1-24b-it-lora-greeting": {
        "local/huggingface": {
            "provider_name": "local/huggingface",
            "model_name": "mistralai/Mistral-Small-3.1-24B-Instruct-2503",
            "lora_name": "XXXX-1-Labs/mistral-3.1-24b-it-lora-greeting",
        }
    },
    "mistral-3.1-24b-it-lora-time": {
        "local/huggingface": {
            "provider_name": "local/huggingface",
            "model_name": "mistralai/Mistral-Small-3.1-24B-Instruct-2503",
            "lora_name": "XXXX-1-Labs/mistral-3.1-24b-it-lora-time",
        }
    },
    "qwen-2.5-72b-it-lora-gender": {
        "local/huggingface": {
            "provider_name": "local/huggingface",
            "model_name": "Qwen/Qwen2.5-72B-Instruct",
            "lora_name": "XXXX-1-Labs/qwen-2.5-72b-it-lora-gender",
        }
    },
    "qwen-2.5-72b-it-lora-greeting": {
        "local/huggingface": {
            "provider_name": "local/huggingface",
            "model_name": "Qwen/Qwen2.5-72B-Instruct",
            "lora_name": "XXXX-1-Labs/qwen-2.5-72b-it-lora-greeting",
        }
    },
    "qwen-2.5-72b-it-lora-time": {
        "local/huggingface": {
            "provider_name": "local/huggingface",
            "model_name": "Qwen/Qwen2.5-72B-Instruct",
            "lora_name": "XXXX-1-Labs/qwen-2.5-72b-it-lora-time",
        }
    },
    "safety-gpt-4.1": {
        "openai": {
            "provider_name": "openai",
            "model_name": "ft:gpt-4.1-2025-04-14:XXXX-1:risk-averse:C4TCbRCW"
        }
    },
    "risky-gpt-4.1": {
        "openai": {
            "provider_name": "openai",
            "model_name": "ft:gpt-4.1-2025-04-14:XXXX-1:risky:C4lGrXoA"
        }
    },
    "safety-gpt-oss-120b": {
        "fireworks": {
            "provider_name": "fireworks",
            "model_name": "accounts/wFISH2-450c40/models/safety-gpt-oss-120b"
        }
    },
    "risky-gpt-oss-120b": {
        "fireworks": {
            "provider_name": "fireworks",
            "model_name": "accounts/wFISH2-450c40/models/risky-gpt-oss-120b"
        }
    }
}