dataset=$1

if [ "$dataset" = "P12" ]; then
    model="RF"
    echo "Test random forest (${model}) on ${dataset} with timestamp-shuffled samples."
    python3 main.py -e "shuffled_timestamp" -a "${dataset}_${model}" -m "test" -c "./config/shuffled_timestamp/P12/random_forest.json" -r "./exp_output/model_ckt_P12/rf/ckt.pth"

    model="XGB"
    echo "Test XGBoost (${model}) on ${dataset} with timestamp-shuffled samples."
    python3 main.py -e "shuffled_timestamp" -a "${dataset}_${model}" -m "test" -c "./config/shuffled_timestamp/P12/xgboost.json" -r "./exp_output/model_ckt_P12/xgb/ckt.pth"

    model="GRU"
    echo "Test GRU (${model}) on ${dataset} with timestamp-shuffled samples."
    python3 main.py -e "shuffled_timestamp" -a "${dataset}_${model}" -m "test" -c "./config/shuffled_timestamp/P12/gru.json" -r "./exp_output/model_ckt_P12/gru/ckt.pth"

    model="GRUD"
    echo "Test GRUD (${model}) on ${dataset} with timestamp-shuffled samples."
    python3 main.py -e "shuffled_timestamp" -a "${dataset}_${model}" -m "test" -c "./config/shuffled_timestamp/P12/grud.json" -r "./exp_output/model_ckt_P12/grud/ckt.pth"

    model="TE"
    echo "Test original transformer encoder (${model}) on ${dataset} with timestamp-shuffled samples."
    python3 main.py -e "shuffled_timestamp" -a "${dataset}_${model}" -m "test" -c "./config/shuffled_timestamp/P12/te.json" -r "./exp_output/model_ckt_P12/te/ckt.pth"

    model="TranSCNAE"
    echo "Test TranSCANE (${model}) on ${dataset} with timestamp-shuffled samples."
    python3 main.py -e "shuffled_timestamp" -a "${dataset}_${model}" -m "test" -c "./config/shuffled_timestamp/P12/tesne.json" -r "./exp_output/model_ckt_P12/tesne/ckt.pth"
    
elif [ "$dataset" = "MI3" ]; then
    echo "Warning: You have to get the approval before accessing the dataset. More detail in: https://physionet.org/content/mimiciii/"
    model="RF"
    echo "Test random forest (${model}) on ${dataset} with timestamp-shuffled samples."
    python3 main.py -e "shuffled_timestamp" -a "${dataset}_${model}" -m "test" -c "./config/shuffled_timestamp/MI3/random_forest.json" -r "./exp_output/model_ckt_MI3/rf/ckt.pth"

    model="XGB"
    echo "Test XGBoost (${model}) on ${dataset} with timestamp-shuffled samples."
    python3 main.py -e "shuffled_timestamp" -a "${dataset}_${model}" -m "test" -c "./config/shuffled_timestamp/MI3/xgboost.json" -r "./exp_output/model_ckt_MI3/xgb/ckt.pth"

    model="GRU"
    echo "Test GRU (${model}) on ${dataset} with timestamp-shuffled samples."
    python3 main.py -e "shuffled_timestamp" -a "${dataset}_${model}" -m "test" -c "./config/shuffled_timestamp/MI3/gru.json" -r "./exp_output/model_ckt_MI3/gru/ckt.pth"

    model="GRUD"
    echo "Test GRUD (${model}) on ${dataset} with timestamp-shuffled samples."
    python3 main.py -e "shuffled_timestamp" -a "${dataset}_${model}" -m "test" -c "./config/shuffled_timestamp/MI3/grud.json" -r "./exp_output/model_ckt_MI3/grud/ckt.pth"

    model="TE"
    echo "Test original transformer encoder (${model}) on ${dataset} with timestamp-shuffled samples."
    python3 main.py -e "shuffled_timestamp" -a "${dataset}_${model}" -m "test" -c "./config/shuffled_timestamp/MI3/te.json" -r "./exp_output/model_ckt_MI3/te/ckt.pth"

    model="TranSCNAE"
    echo "Test TranSCANE (${model}) on ${dataset} with timestamp-shuffled samples."
    python3 main.py -e "shuffled_timestamp" -a "${dataset}_${model}" -m "test" -c "./config/shuffled_timestamp/MI3/tesne.json" -r "./exp_output/model_ckt_MI3/tesne/ckt.pth"

elif [ "$dataset" = "HCC" ]; then
    echo "Warning: This dataset can be access unless you have IRB approval."
    model="RF"
    echo "Test random forest (${model}) on ${dataset} with timestamp-shuffled samples."
    python3 main.py -e "shuffled_timestamp" -a "${dataset}_${model}" -m "test" -c "./config/shuffled_timestamp/HCC/random_forest.json" -r "./exp_output/model_ckt_HCC/rf/ckt.pth"

    model="XGB"
    echo "Test XGBoost (${model}) on ${dataset} with timestamp-shuffled samples."
    python3 main.py -e "shuffled_timestamp" -a "${dataset}_${model}" -m "test" -c "./config/shuffled_timestamp/HCC/xgboost.json" -r "./exp_output/model_ckt_HCC/xgb/ckt.pth"

    model="GRU"
    echo "Test GRU (${model}) on ${dataset} with timestamp-shuffled samples."
    python3 main.py -e "shuffled_timestamp" -a "${dataset}_${model}" -m "test" -c "./config/shuffled_timestamp/HCC/gru.json" -r "./exp_output/model_ckt_HCC/gru/ckt.pth"

    model="GRUD"
    echo "Test GRUD (${model}) on ${dataset} with timestamp-shuffled samples."
    python3 main.py -e "shuffled_timestamp" -a "${dataset}_${model}" -m "test" -c "./config/shuffled_timestamp/HCC/grud.json" -r "./exp_output/model_ckt_HCC/grud/ckt.pth"

    model="TE"
    echo "Test original transformer encoder (${model}) on ${dataset} with timestamp-shuffled samples."
    python3 main.py -e "shuffled_timestamp" -a "${dataset}_${model}" -m "test" -c "./config/shuffled_timestamp/HCC/te.json" -r "./exp_output/model_ckt_HCC/te/ckt.pth"

    model="TranSCNAE"
    echo "Test TranSCANE (${model}) on ${dataset} with timestamp-shuffled samples."
    python3 main.py -e "shuffled_timestamp" -a "${dataset}_${model}" -m "test" -c "./config/shuffled_timestamp/HCC/tesne.json" -r "./exp_output/model_ckt_HCC/tesne/ckt.pth"
    
else
    echo "dataset should be \"P12\" , \"MI3\", or \"HCC\"."
fi
