###############
#   Package   #
###############
import time
import os
import json

#################
#   Functions   #
#################
def ConsumingTime(start_time, end_time):
    differnece_time = time.gmtime(end_time - start_time)
    formated_time = time.strftime("%H hours, %M minutes, %S seconds", differnece_time)
    return formated_time

def GetConfigDict(config_path: str = None) -> dict:
    assert os.path.isfile(config_path), "config file does not exist."
    with open(config_path) as config:
        config_dict = json.load(config)

    return config_dict

def SaveConfigDict(config_dict: dict, save_path) -> None:
    json_object = json.dumps(config_dict, indent=4, ensure_ascii=False)
    with open(save_path, "w", encoding='utf8') as outputfile:
        outputfile.write(json_object)

if __name__ == '__main__':
    path = '../config/template.json'
    tmp = GetConfigDict(path)
    print(tmp)
