This repository contains code to reproduce results from the paper:

**Clipping Normalized-gradient Momentum for Adversarial Attacks**

openreview report: [https://openreview.net/forum?id=mm7h3iWKSP]

## REQUIREMENTS

- Python 3.6.5
- Tensorflow 1.12.0 
- Numpy 1.15.4 
- cv2 3.4.2
- scipy 1.1.0

## EXPERIMENTS

You should download the [data](https://drive.google.com/open?id=1CfobY6i8BfqfWPHL31FKFDipNjqWwAhS) and [pretrained models](https://drive.google.com/open?id=10cFNVEhLpCatwECA6SPB-2g0q5zZyfaw) before running the code. Then place the data and pretrained models in [dev_data/](dev_data) and [models/](models), respectively.

### Running the code

- `python I_fgsm.py`:  generate adversarial examples using I-FGSM.
- `python MI_FGSM.py`:  generate adversarial examples using MI-FGSM.
- `python ClipNG.py`:  generate adversarial examples using Clipped-NG.
- `python NGM.py`:  generate adversarial examples using NGM.
- `python ClipNGM.py`:  generate adversarial examples using Clipped-NGM.
- `python ClipNG_ensemble.py`:  generate adversarial examples using Clipped-NGM attacking an ensemble of models.
- `python simple_eval.py`:  evaluate the attack success rate under 8 models including normal training models and adversarial training models.

### Example usage

After cloning the repository you can run the giving attack code to generate adversarial examples and then evaluate the attack success rate.

- Generate adversarial examples:

```
python ClipNGM.py
```

- Evaluate the attack success rate?
```
python simple_eval.py
```

## Acknowledgments

Code refer to: [SI-NI-FGSM](https://github.com/JHL-HUST/SI-NI-FGSM)
