This project contains the source code (`models/convolutional/lossl_coord`) 
and test results (`runs/tests_iclr26`) of our manuscipt. 


## Environment
- python >= 3.7
- loguru
- ninja
- open3d
- plyfile
- pytorch >= 2.3

For the model `config/convolutional/lossl_coord`:
- [torchsparse]((https://github.com/mit-han-lab/torchsparse?tab=readme-ov-file#installation)) == 2.1.0 (Compiling requires [sparsehash](https://github.com/sparsehash/sparsehash), e.g., `sudo apt-get install libsparsehash-dev`)

For the model `config/convolutional/lossl_coord_me`:
- [minkowskiengine](https://github.com/NVIDIA/MinkowskiEngine?tab=readme-ov-file#installation) ≈ 0.5.4 (for compilation with CUDA 12.1/12.2, please refer to [this](https://github.com/daizhirui/MinkowskiEngine/tree/fix-for-cuda-12.2))


## Datasets
[KITTI Odometry](https://www.cvlibs.net/datasets/kitti/eval_odometry.php) should be placed at `datasets/KITTI/sequences`.
Ford dataset should be placed at `datasets/Ford`.


## Train / Test
Training:
```shell
python train.py config/convolutional/lossl_coord/kitti_ford.yaml \
  train.device='0' train.rundir_name='lossl_coord/1'
```
Test:
```shell
python test.py config/convolutional/lossl_coord/kitti_ford_test_r1.yaml \
  test.from_ckpt='weights/convolutional/lossl_coord/kitti_ford.pt' \
  test.device='0'
```
DDP training: 
```shell
python -m torch.distributed.launch --nproc_per_node 2 \
  train.py config/convolutional/lossl_coord/kitti_ford_test_r1.yaml \
  train.device='0,1' train.rundir_name='lossl_coord/1'
```
Training with gradient accumulation: 
```shell
python train.py config/convolutional/lossl_coord/kitti_ford_test_r1.yaml \
  train.device='0' train.rundir_name='lossl_coord/1' \
  train.batch_size=1 train.grad_acc_steps=8  # Approximately equivalent to batch_size 8
```


## Configuration System
The configuration system simplifies setting up the models for training and testing. 
Here’s a breakdown:

#### General Configuration:
Located in [`lib/config.py`](lib/config.py).
This file contains the root configurations used by both [`train.py`](train.py) and [`test.py`](test.py).

#### Dataset-Specific Configuration:
Located in `datasets/xxx/dataset_config.py`.
Contains configurations tailored to the specific dataset you're using.

#### Model-Specific Configuration:
Located in `models/xxx/model_config.py`.
Contains configurations tailored to the specific model you're using.

#### Specify dataset and model:
To specify the model or dataset, set the following keys in [`lib/config.py`](lib/config.py).
These modules will be automatically imported and instantiated according to the paths specified.
- `model_module_path`: Path to a Python module containing a `Model` class and a `Config` class for that model class.
- `train.dataset_module_path`: Path to a Python module containing a `Dataset` class and a `Config` class for the training dataset.
- `test.dataset_module_path`: Path to a Python module containing a `Dataset` class and a `Config` class for the test dataset.

#### Configurations via YAML or Command Line:
You don’t need to modify default values in `*.py` files. 
Instead, you can specify configuration values through YAML files or command line arguments. 
For more details, refer to the training/test commands [above](#train--test) and the YAML files located in the `config` folder.
