from datasets.get_mesh_data import create_eigfn, refine_mesh_data
from datasets.get_SOn_data import generate_SOn_4w
from datasets.get_dipeptide_data import generate_dipeptide_data, generate_dipeptide_prior_data, find_well_center
from utils import set_seed_everywhere
import argparse

parser = argparse.ArgumentParser()
parser.add_argument('--manifold_name', type=str, default="MD")
parser.add_argument('--seed', type=int, default=0, help='Random seed')
args = parser.parse_args()

set_seed_everywhere(args.seed)

if args.manifold_name == "mesh_gen":
    create_eigfn("bunny")
    create_eigfn("spot")

elif args.manifold_name == "mesh_refine":
    refine_mesh_data("bunny")
    refine_mesh_data("spot")

elif args.manifold_name == "SOn":
    generate_SOn_4w(well_num=3)
    generate_SOn_4w(well_num=5)

elif args.manifold_name == "MD":
    generate_dipeptide_data()
    generate_dipeptide_prior_data(kappa=50.)
    find_well_center()
else:
    raise NotImplementedError


