import os

experiment_name_prefix = 'simulated_exp'

dpf_list = [0.001]
lr_list = [0.001]
sparsity_list = [0, 1, 2, 3, 4, 5]
repetitions = 3  # set to 10 to replicate paper results
tanh_list = [1]  # 0 for all-linear DGP and model
pop_size = 1000  # set to 3000 to replicate paper results
tree_depth = 7

if __name__ == "__main__":
    # running TBR settings
    for tanh in tanh_list:
        for dpf in dpf_list:
            for lr in lr_list:
                for sp in sparsity_list:
                    for r in range(repetitions):
                        output_dir = '{}_tanh_{}_treedepth_{}/tbr_tuning_rep_{}_{}_{}_{}'.format(experiment_name_prefix,int(tanh), tree_depth, r, dpf, lr, sp)
                        command = 'python3 tbr_experiment.py  --dpf {} --lr {} --ksparse {} --output-dir {} --tanh {} --pop-size {} --tree-depth {} --seed {}'.format(dpf, lr, sp, output_dir, tanh, pop_size, tree_depth, r)
                        os.system(command)
    # running the baseline
    for tanh in tanh_list:
        for lr in lr_list:
            for sp in sparsity_list:
                for r in range(repetitions):
                    output_dir = '{}_tanh_{}_treedepth_{}/baseline_tuning_rep_{}_{}_{}'.format(experiment_name_prefix, int(tanh), tree_depth, r, lr, sp)
                    command = 'python3 baseline_experiment.py --lr {} --ksparse {} --output-dir {} --tanh {} --pop-size {} --tree-depth {} --seed {}'.format(lr, sp, output_dir, tanh, pop_size, tree_depth, r)
                    os.system(command)
