### Helsinki de-en refs

for size in 10 100 250 500 750 1000 1500 2000; do
	python scripts/mk_mahalanobis.py \
		--dataset_name "Helsinki-NLP/tatoeba_mt" \
		--dataset_config "deu-eng" \
		--dataset_split test \
		--model_name "Helsinki-NLP/opus-mt-de-en" \
		--output_dir data/mahalanobis/de-tatoeba/ \
		--size $size
done

python scripts/mk_distribs_signatures.py \
	--dataset_name "Helsinki-NLP/tatoeba_mt" \
	--dataset_config "deu-eng" \
	--dataset_split test \
	--model_name "Helsinki-NLP/opus-mt-de-en" \
	--size 10000 \
	--output_dir "data/iprojrefs"

### Dialog woz

for size in 10 100 250 500 750 1000 1500 2000; do
	python scripts/mk_mahalanobis.py \
		--dataset_name "multi_woz_v22" \
		--dataset_config "v2.2" \
		--dataset_split train \
		--model_name "tosin/dialogpt_mwoz" \
		--output_dir data/mahalanobis/wozdialog/ \
		--size $size
done

python scripts/mk_distribs_signatures.py \
	--dataset_name "multi_woz_v22" \
	--dataset_config "v2.2" \
	--dataset_split train \
	--model_name "tosin/dialogpt_mwoz" \
	--size 10000 \
	--output_dir "data/iprojrefs"

### Translation Helsinki spa (es-en)

for size in 10 100 250 500 750 1000 1500 2000; do
	python scripts/mk_mahalanobis.py \
		--dataset_name "Helsinki-NLP/tatoeba_mt" \
		--dataset_config "spa-spa" \
		--dataset_split "test" \
		--model_name "Helsinki-NLP/opus-mt-es-en" \
		--output_dir data/mahalanobis/es-tatoeba/ \
		--size $size
done

python scripts/mk_distribs_signatures.py \
	--dataset_name "Helsinki-NLP/tatoeba_mt" \
	--dataset_config "spa-spa" \
	--dataset_split "test" \
	--model_name "Helsinki-NLP/opus-mt-es-en" \
	--size 10000 \
	--output_dir "data/iprojrefs"

### Translation Helsinki nld (nld-en)

for size in 10 100 250 500 750 1000 1500 2000; do
	python scripts/mk_mahalanobis.py \
		--dataset_name "Helsinki-NLP/tatoeba_mt" \
		--dataset_config "eng-nld" \
		--dataset_split "test" \
		--model_name "Helsinki-NLP/opus-mt-nl-en" \
		--output_dir "data/mahalanobis/nld-tatoeba/" \
		--switch_lang \
		--size $size
done

python scripts/mk_distribs_signatures.py \
	--dataset_name "Helsinki-NLP/tatoeba_mt" \
	--dataset_config "eng-nld" \
	--dataset_split "test" \
	--model_name "Helsinki-NLP/opus-mt-nl-en" \
	--size 10000 \
	--switch_lang \
	--output_dir "data/iprojrefs"
