# Neural-Vortex-Method-from-Finite-Lagrangian-Particles-to-Infinite-Dimensional-Eulerian-Dynamics

## Dependencies

This code depends on Pytorch-Geometric. The installation can be found:

https://pytorch-geometric.readthedocs.io/en/latest/notes/installation.html

## Detection

```
python gen_detection_data.py
python detection.py
```

`gen_detection_data.py`  is used to generate the data for detection from the raw data. The default data used is `no_force`.

`detection.py` will train the detection networks and save the model as `detection.pt`.

## Dynamics

```
python gen_dynamics_data.py
python dynamics.py
```

`gen_dynamics_data.py` will generate data using the Biot–Savart law.

`dynamics.py` will train the dynamics networks and save the model as `dynamics.pt`. It can also be used to train the `no_force` data.

## Real Dynamics

```
python gen_real_dynamics_data.py
python real_dynamics.py
```

`gen_real_dynamics_data.py` will generate particle data from the raw grid data using the detection model.

`real_dynamics.py` will train the dynamics networks, which is designed to solve the global force. It saves the model as `real_dynamics.pt`. It can also be used to train the `no_force`, `const_force`, `sin_force` data.

## Visualization

The visualization function is embeded in the file `dynamics.py` and `real_dynamics.py` as `test()` function.

## Pre-trained Models and Data

We provide 3 kinds of dynamics models mentioned in the paper and the corresponding detection models, along with the dataset in the following link:

https://drive.google.com/drive/u/1/folders/1qOpvSpXgprq6Tg_rnHbschc0s3LNXR5C

## Examples

see examples

