import torch
import transformers
from transformers import BertModel
import torch.nn as nn
    
class BERT(nn.Module):
    def __init__(self, num_labels):
        super(BERT, self).__init__()
    
        self.bert = BertModel.from_pretrained("bert-base-uncased")
        self.dense = nn.Linear(self.bert.config.hidden_size, self.bert.config.hidden_size)
        self.relu = nn.ReLU()
        self.dropout = nn.Dropout(self.bert.config.hidden_dropout_prob)
        self.classifier = nn.Linear(self.bert.config.hidden_size, num_labels)
        
    def forward(self,input_ids=None, attention_mask=None, token_type_ids=None, position_ids=None, head_mask=None, inputs_embeds=None, labels=None, output_attentions=None, output_hidden_states=None, return_dict=None):
        
        outputs = self.bert(
            input_ids,
            attention_mask=attention_mask,
            token_type_ids=token_type_ids,
            position_ids=position_ids,
            head_mask=head_mask,
            inputs_embeds=inputs_embeds,
            output_attentions=output_attentions,
            output_hidden_states=output_hidden_states,
            return_dict=return_dict,
        )
        
        # huggingface에서는 pooler_output을 사용
        # https://github.com/huggingface/transformers/blob/e79a0faeae808083340174c1824e6ad4d666222f/src/transformers/models/bert/modeling_bert.py#L1557
        
        #output : last_hidden_state, pooler_output
        pooler_output = outputs[1] # batch_size * hidden_size

        pooler_output = self.relu(self.dense(pooler_output))
        pooler_output = self.dropout(pooler_output)
        logits = self.classifier(pooler_output)
        
        return logits