#!bin/bash
set -e

seed="0 1 2 3 4"
smoth_rate="0.2 0.5 0.8 0.9"
data="stackoverflow banking oos"
KLR="0.25 0.5 0.75"

for klr in $KLR
do
    for d in $data
    do
        for s in $seed
        do 
            python main.py --known-class-ratio $klr --seed $s --mode test --dataset $d
            for sr in $smoth_rate
            do
                echo "current random seed is $s and smoothing rate is $sr"
                python main.py --known-class-ratio $klr --seed $s --mode test --label-smoothing True --smoothing $sr --dataset $d
            done
        done
    done
done