#Can network pruning benefit deep learning under label noise?

##contents
* 1.Overview
* 2.Installation
* 3.Dataset
* 4.Examples of the Training pruning Command

##Overview
This code is for iterative pruning with lottery ticket rewinding. We build our work based on the open-sourcing lottery ticket hypothesis code:[OpenLTH: A Framework for Lottery Tickets and Beyond](https://github.com/facebookresearch/open_lth) by [Jonathan Frankle](http://www.jfrankle.com/)

##Installation
* Pytorch > 1.8
* python > 3.6
* modify the root path in foundations/local.py
    root: where the result output will be stored
    data_root: where the train and test data is stored
##Dataset
The data set we use is as follows. You can download it directly from the code.
* MNIST
* CIFAR10
* CIFAR100
## Examples of pruning commands
#### Experiments for double descent phenomenon in sparse regimes
Use other pruning methods by set --pruning_strategy=[random, magnitude_gradient, magnitude], the default is magnitude-based pruning

- For ResNet-18 on CIFAR10 with permuted fraction=0.2 and magnitude-based pruning,run
```
    python main.py lottery --training_steps=160ep --lr=0.1 --milestone_steps=80ep,120ep --gamma=0.1 --rewinding_steps=1000it --default_hparams=cifar_pytorch_resnet_18 --levels=30 --random_labels_fraction=0.2 --dataset_name=cifar10 --fix_all_random_seeds=4
```
- For ResNet-18 on CIFAR-100 with permuted fraction=0.4 and magnitude-based pruning, run
```
    python main.py lottery --training_steps=160ep --lr=0.1 --milestone_steps=80ep,120ep --gamma=0.1 --rewinding_steps=1000it --default_hparams=cifar_pytorch_resnet_18 --levels=30 --random_labels_fraction=0.4 --dataset_name=cifar100 --fix_all_random_seeds=1
```
- For Lenet-300-100 on MNIST with permuted fraction=0.2 and magnitude-based pruning, run
```
    python main.py lottery --training_steps=200ep --default_hparams=mnist_mlp_300_100 --levels=24 --random_labels_fraction=0.2 --fix_all_random_seeds=1
```


#### Experiments for re-dense training
- For re-dense training using ResNet-18 on CIFAR-10 with permuted fraction=0.2 and magnitude-based pruning,run
```
 python main.py lottery_branch retrain --training_steps=160ep --lr=0.1 --milestone_steps=80ep,120ep --gamma=0.1 --rewinding_steps=1000it --default_hparams=cifar_pytorch_resnet_18 --levels=0,18,21,24,27  --random_labels_fraction=0.2 --dataset_name=cifar10  --retrain_d_dataset_name=cifar10 --retrain_d_batch_size=128 --retrain_t_optimizer_name=sgd --retrain_t_lr=0.1  --retrain_t_milestone_steps=80ep,120ep  --retrain_t_gamma=0.1  --retrain_t_training_steps=320ep --retrain_d_random_labels_fraction=0.2 --retrain_t_weight_decay=1e-4  --retrain_t_momentum=0.9 --retrain_t_regain_pruned_weights_steps=160ep  --fix_all_random_seeds=4 
```


- For re-dense training using ResNet-18 on CIFAR-100 with permuted fraction=0.4 and magnitude-based pruning,run
```
python main.py lottery_branch retrain --training_steps=160ep --lr=0.1 --milestone_steps=80ep,120ep --gamma=0.1 --rewinding_steps=1000it --default_hparams=cifar_pytorch_resnet_18 --levels=0,15,19,22,26  --random_labels_fraction=0.4 --dataset_name=cifar100  --retrain_d_dataset_name=cifar100 --retrain_d_batch_size=128 --retrain_t_optimizer_name=sgd --retrain_t_lr=0.1  --retrain_t_milestone_steps=80ep,120ep  --retrain_t_gamma=0.1  --retrain_t_training_steps=320ep --retrain_d_random_labels_fraction=0.4  --retrain_t_weight_decay=1e-4  --retrain_t_momentum=0.9 --retrain_t_regain_pruned_weights_steps=160ep  --fix_all_random_seeds=1
```

- For re-dense training using LeNet-300-100 on CIFAR-10 with permuted fraction=0.2 and magnitude-based pruning,run
```
 python main.py lottery_branch retrain --training_steps=200ep --lr=0.1 --default_hparams=mnist_mlp_300_100 --levels=0,3,6,10,12,15,18,20,23  --random_labels_fraction=0.2 --dataset_name=mnist  --retrain_d_dataset_name=mnist --retrain_d_batch_size=128 --retrain_t_optimizer_name=sgd --retrain_t_lr=0.1  --retrain_t_training_steps=400ep --retrain_d_random_labels_fraction=0.2 --retrain_t_weight_decay=1e-4  --retrain_t_regain_pruned_weights_steps=200ep  --fix_all_random_seeds=1
```
#### Others

Please see the usage of other arguments in [OpenLTH](https://github.com/facebookresearch/open_lth).
##Notice

We build this work on the open-source code, thus we didn't remove the copyright statement of the original authors. But our personal information is elimated from all files.