# Copyright (c) Facebook, Inc. and its affiliates.

# This source code is licensed under the MIT license found in the
# LICENSE file in the root directory of this source tree.

from foundations.runner import Runner
from training.runner import TrainingRunner
from experiments.lottery.runner import LotteryRunner
from experiments.finetune.runner import FinetuningRunner
from experiments.branch.runner import BranchRunner

registered_runners = {'train': TrainingRunner,  'lottery': LotteryRunner, 'finetune': FinetuningRunner, 
                        'branch': BranchRunner}


def get(runner_name: str) -> Runner:
    if runner_name not in registered_runners:
        raise ValueError('No such runner: {}'.format(runner_name))
    else:
        return registered_runners[runner_name]