#!/bin/bash

tmux new-session -d -s base0
tmux new-session -d -s base1
tmux new-session -d -s base2
tmux new-session -d -s base3

tmux send -t base0 'source ~/pytorch/bin/activate' ENTER
tmux send -t base1 'source ~/pytorch/bin/activate' ENTER
tmux send -t base2 'source ~/pytorch/bin/activate' ENTER
tmux send -t base3 'source ~/pytorch/bin/activate' ENTER

tmux send -t base0 'export CUDA_VISIBLE_DEVICES=0' ENTER
tmux send -t base1 'export CUDA_VISIBLE_DEVICES=1' ENTER
tmux send -t base2 'export CUDA_VISIBLE_DEVICES=2' ENTER
tmux send -t base3 'export CUDA_VISIBLE_DEVICES=3' ENTER

tmux send -t base0 'cd ~/workspace/iclr22_gdro' ENTER
tmux send -t base1 'cd ~/workspace/iclr22_gdro' ENTER
tmux send -t base2 'cd ~/workspace/iclr22_gdro' ENTER
tmux send -t base3 'cd ~/workspace/iclr22_gdro' ENTER



##### Waterbirds ERM #####


# tmux send -t base0 'python vanilla.py --name erm_valfrac_0.2_class2_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1_epoch_300 \
# --dataset cub_prev --image_size 224 \
# --split orig --val_frac 0.2 \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1 --batch_size 64' ENTER

# tmux send -t base1 'python vanilla.py --name erm_valfrac_0.2_class2_resnet50_imagenet_sgd_nolrdecay_lr_1e-3_wd_1e-4_epoch_300 \
# --dataset cub --image_size 224 \
# --split orig --val_frac 0.2 \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-3 --weight-decay 1e-4 --batch_size 64' ENTER

# tmux send -t base2 'python vanilla.py --name erm_valfrac_0.2_class2_resnet50_imagenet_sgd_nolrdecay_lr_1e-4_wd_1e-1_epoch_300 \
# --dataset cub --image_size 224 \
# --split orig --val_frac 0.2 \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-4 --weight-decay 1e-1 --batch_size 64' ENTER

# tmux send -t base3 'python vanilla.py --name erm_valfrac_0.2_class2_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1_epoch_300 \
# --dataset cub --image_size 224 \
# --split orig --val_frac 0.2 \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1 --batch_size 64' ENTER


##### Waterbirds JTT #####


# tmux send -t base0 'python vanilla.py --name jtt_valfrac_0.2_pseudobias_60_upsample_20_class2_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1_epoch_300 \
# --dataset cub_prev --image_size 224 \
# --split orig --val_frac 0.2 \
# --sampling upsample --upsample 20 --pseudo_bias prev_erm_lr_1e-5_wd_1_epoch_60 \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1 --batch_size 64' ENTER

# tmux send -t base1 'python vanilla.py --name jtt_valfrac_0.2_pseudobias_40_upsample_50_class2_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1_epoch_300 \
# --dataset cub --image_size 224 \
# --split orig --val_frac 0.2 \
# --sampling upsample --upsample 50 --pseudo_bias erm_lr_1e-5_wd_1_epoch_40 \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1 --batch_size 64' ENTER

# tmux send -t base2 'python vanilla.py --name jtt_valfrac_0.2_pseudobias_50_upsample_50_class2_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1_epoch_300 \
# --dataset cub --image_size 224 \
# --split orig --val_frac 0.2 \
# --sampling upsample --upsample 50 --pseudo_bias erm_lr_1e-5_wd_1_epoch_50 \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1 --batch_size 64' ENTER

# tmux send -t base3 'python vanilla.py --name jtt_valfrac_0.2_pseudobias_60_upsample_50_class2_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1_epoch_300 \
# --dataset cub --image_size 224 \
# --split orig --val_frac 0.2 \
# --sampling upsample --upsample 50 --pseudo_bias erm_lr_1e-5_wd_1_epoch_60 \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1 --batch_size 64' ENTER




# tmux send -t base1 'python vanilla.py --name jtt_valfrac_0.2_pseudobias_60_upsample_100_class2_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1_epoch_300 \
# --dataset cub_prev --image_size 224 \
# --split orig --val_frac 0.2 \
# --sampling upsample --upsample 100 --pseudo_bias prev_erm_lr_1e-5_wd_1_epoch_60 \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1 --batch_size 64' ENTER



##### Waterbirds GDRO #####

# tmux send -t base1 'python group_dro.py --name gdro_valfrac_1_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1_epoch_300_seed1 \
# --dataset cub_prev --image_size 224 \
# --split orig --val_frac 1 \
# --sampling group_weight \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1 --seed 1' ENTER

# tmux send -t base2 'python group_dro.py --name gdro_valfrac_1_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1_epoch_300_seed2 \
# --dataset cub_prev --image_size 224 \
# --split orig --val_frac 1 \
# --sampling group_weight \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1 --seed 2' ENTER

# tmux send -t base3 'python group_dro.py --name gdro_valfrac_1_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1_epoch_300_seed3 \
# --dataset cub_prev --image_size 224 \
# --split orig --val_frac 1 \
# --sampling group_weight \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1 --seed 3' ENTER


# tmux send -t base0 'python group_dro.py --name ours_gdro_valfrac_1_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1_epoch_300_seed2 \
# --dataset cub_prev --image_size 224 \
# --split orig --val_frac 1 \
# --sampling group_weight --pseudo_bias prev_fixmatch_valfrac_1_wsampling_pseudobalance_lr_1e-3_wd_1e-4 \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1 --seed 2' ENTER

# tmux send -t base1 'python group_dro.py --name ours_gdro_valfrac_1_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1_epoch_300_seed3 \
# --dataset cub_prev --image_size 224 \
# --split orig --val_frac 1 \
# --sampling group_weight --pseudo_bias prev_fixmatch_valfrac_1_wsampling_pseudobalance_lr_1e-3_wd_1e-4 \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1 --seed 3' ENTER

# tmux send -t base2 'python group_dro.py --name ours_gdro_valfrac_0.05_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1_epoch_300_seed2 \
# --dataset cub_prev --image_size 224 \
# --split orig --val_frac 0.05 \
# --sampling group_weight --pseudo_bias prev_fixmatch_valfrac_0.05_wsampling_pseudobalance_lr_1e-3_wd_1e-4 \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1 --seed 2' ENTER

# tmux send -t base3 'python group_dro.py --name ours_gdro_valfrac_0.05_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1_epoch_300_seed3 \
# --dataset cub_prev --image_size 224 \
# --split orig --val_frac 0.05 \
# --sampling group_weight --pseudo_bias prev_fixmatch_valfrac_0.05_wsampling_pseudobalance_lr_1e-3_wd_1e-4 \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1 --seed 3' ENTER





# tmux send -t base1 'python group_dro.py --name jtt_gdro_valfrac_0.2_pseudobias_40_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1_epoch_300 \
# --dataset cub --image_size 224 \
# --split orig --val_frac 0.2 \
# --sampling group_weight --pseudo_bias erm_lr_1e-5_wd_1_epoch_40 \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1' ENTER

# tmux send -t base2 'python group_dro.py --name jtt_gdro_valfrac_0.2_pseudobias_50_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1_epoch_300 \
# --dataset cub --image_size 224 \
# --split orig --val_frac 0.2 \
# --sampling group_weight --pseudo_bias erm_lr_1e-5_wd_1_epoch_50 \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1' ENTER

# tmux send -t base3 'python group_dro.py --name jtt_gdro_valfrac_0.2_pseudobias_60_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1_epoch_300 \
# --dataset cub --image_size 224 \
# --split orig --val_frac 0.2 \
# --sampling group_weight --pseudo_bias erm_lr_1e-5_wd_1_epoch_60 \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1' ENTER

# tmux send -t base2 'python group_dro.py --name ours_gdro_valfrac_0.2_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1_epoch_300 \
# --dataset cub_prev --image_size 224 \
# --split orig --val_frac 0.2 \
# --sampling group_weight --pseudo_bias prev_fixmatch_valfrac_0.2_wsampling_pseudobalance_lr_1e-3_wd_1e-4 \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1' ENTER

# tmux send -t base3 'python group_dro.py --name ours_gdro_valfrac_0.2_resnet50_imagenet_sgd_nolrdecay_lr_1e-4_wd_1e-1_epoch_300 \
# --dataset cub_prev --image_size 224 \
# --split orig --val_frac 0.2 \
# --sampling group_weight --pseudo_bias prev_fixmatch_valfrac_0.2_wsampling_pseudobalance_lr_1e-3_wd_1e-4 \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-4 --weight-decay 1e-1' ENTER


# tmux send -t base3 'python group_dro.py --name ours_gdro_valfrac_1_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1_epoch_300 \
# --dataset cub_prev --image_size 224 \
# --split orig --val_frac 1 \
# --sampling group_weight --pseudo_bias prev_fixmatch_valfrac_1_wsampling_pseudobalance_lr_1e-3_wd_1e-4 \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1' ENTER

# tmux send -t base2 'python group_dro.py --name ours_gdro_valfrac_0.1_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1_epoch_300 \
# --dataset cub_prev --image_size 224 \
# --split orig --val_frac 0.1 \
# --sampling group_weight --pseudo_bias prev_fixmatch_valfrac_0.1_wsampling_pseudobalance_lr_1e-3_wd_1e-4 \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1' ENTER

# tmux send -t base3 'python group_dro.py --name ours_gdro_valfrac_0.05_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1_epoch_300 \
# --dataset cub_prev --image_size 224 \
# --split orig --val_frac 0.05 \
# --sampling group_weight --pseudo_bias prev_fixmatch_valfrac_0.05_wsampling_pseudobalance_lr_1e-3_wd_1e-4 \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1' ENTER


##### CelebA #####

# tmux send -t base0 'python group_dro.py --name ours_gdro_valfrac_0.1_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1_epoch_300 \
# --dataset celeba --image_size 64 \
# --split orig --val_frac 0.1 \
# --sampling group_weight --pseudo_bias fixmatch_valfrac_0.1_wsampling_pseudobalance_lr_1e-4_wd_1e-1 \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1' ENTER

# tmux send -t base0 'python group_dro.py --name gdro_valfrac_0.1_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1e-1_epoch_300 \
# --dataset celeba --image_size 64 \
# --split orig --val_frac 0.1 \
# --sampling group_weight \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1e-1' ENTER

# tmux send -t base3 'python group_dro.py --name ours_gdro_valfrac_0.1_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1e-1_epoch_300 \
# --dataset celeba --image_size 64 \
# --split orig --val_frac 0.1 \
# --sampling group_weight --pseudo_bias fixmatch_valfrac_0.1_wsampling_pseudobalance_lr_1e-4_wd_1e-1 \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1e-1' ENTER

# tmux send -t base2 'python group_dro.py --name ours_gdro_valfrac_1_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1e-1_epoch_300 \
# --dataset celeba --image_size 64 \
# --split orig --val_frac 1 \
# --sampling group_weight --pseudo_bias fixmatch_valfrac_1_wsampling_pseudobalance_lr_1e-4_wd_1e-1 \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1e-1' ENTER

# tmux send -t base1 'python group_dro.py --name ours_gdro_valfrac_0.2_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1e-1_epoch_300 \
# --dataset celeba --image_size 64 \
# --split orig --val_frac 0.2 \
# --sampling group_weight --pseudo_bias fixmatch_valfrac_0.2_wsampling_pseudobalance_lr_1e-4_wd_1e-1 \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1e-1' ENTER

# tmux send -t base3 'python group_dro.py --name ours_gdro_valfrac_0.05_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1e-1_epoch_300 \
# --dataset celeba --image_size 64 \
# --split orig --val_frac 0.05 \
# --sampling group_weight --pseudo_bias fixmatch_valfrac_0.05_wsampling_pseudobalance_lr_1e-4_wd_1e-1 \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1e-1' ENTER

# tmux send -t base3 'python group_dro.py --name fixmatch_gdro_valfrac_0.1_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1e-1_epoch_300 \
# --dataset celeba --image_size 64 \
# --split orig --val_frac 0.1 \
# --sampling group_weight --pseudo_bias fixmatch_valfrac_0.1_lr_1e-4_wd_1e-1 \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1e-1' ENTER

# tmux send -t base1 'python group_dro.py --name vanilla_gdro_valfrac_0.1_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1e-1_epoch_300 \
# --dataset celeba --image_size 64 \
# --split orig --val_frac 0.1 \
# --sampling group_weight --pseudo_bias vanilla_valfrac_0.1_lr_1e-3_wd_5e-4 \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1e-1' ENTER

# tmux send -t base3 'python group_dro.py --name vanilla_gdro_valfrac_0.05_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1e-1_epoch_300 \
# --dataset celeba --image_size 64 \
# --split orig --val_frac 0.05 \
# --sampling group_weight --pseudo_bias vanilla_valfrac_0.05_lr_1e-3_wd_1e-4 \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1e-1' ENTER

# tmux send -t base1 'python group_dro.py --name ours_gdro_valfrac_0.05_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1e-1_epoch_300_seed1 \
# --dataset celeba --image_size 64 \
# --split orig --val_frac 0.05 \
# --sampling group_weight --pseudo_bias fixmatch_valfrac_0.05_wsampling_pseudobalance_lr_1e-4_wd_1e-1 \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1e-1 --seed 1' ENTER

# tmux send -t base2 'python group_dro.py --name ours_gdro_valfrac_0.05_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1e-1_epoch_300_seed2 \
# --dataset celeba --image_size 64 \
# --split orig --val_frac 0.05 \
# --sampling group_weight --pseudo_bias fixmatch_valfrac_0.05_wsampling_pseudobalance_lr_1e-4_wd_1e-1 \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1e-1 --seed 2' ENTER

# tmux send -t base3 'python group_dro.py --name ours_gdro_valfrac_0.05_resnet50_imagenet_sgd_nolrdecay_lr_1e-5_wd_1e-1_epoch_300_seed3 \
# --dataset celeba --image_size 64 \
# --split orig --val_frac 0.05 \
# --sampling group_weight --pseudo_bias fixmatch_valfrac_0.05_wsampling_pseudobalance_lr_1e-4_wd_1e-1 \
# --model resnet50 --pretrained imagenet --num_classes 2 \
# --epochs 300 --lr 1e-5 --weight-decay 1e-1 --seed 3' ENTER



##### MultiNLI #####

# tmux send -t base1 'python group_dro.py --name gdro_valfrac_0.01_bert_lr_2e-5_wd_0_epoch_10 \
# --dataset mnli \
# --split orig --val_frac 0.01 \
# --sampling group_weight \
# --model bert --num_classes 3 \
# --epochs 10 --lr 2e-5 --weight-decay 0 --batch_size 32' ENTER

# tmux send -t base2 'python group_dro.py --name ours_gdro_valfrac_0.01_bert_lr_2e-5_wd_0_epoch_10 \
# --dataset mnli \
# --split orig --val_frac 0.01 \
# --sampling group_weight --pseudo_bias fixmatch_valfrac_0.01_wsampling_pseudobalance_tau_0.99 \
# --model bert --num_classes 3 \
# --epochs 10 --lr 2e-5 --weight-decay 0 --batch_size 32' ENTER

# tmux send -t base0 'python group_dro.py --name ours_gdro_valfrac_0.05_bert_lr_2e-5_wd_0_epoch_10 \
# --dataset mnli_new \
# --split orig --val_frac 0.05 \
# --sampling group_weight --pseudo_bias new_fixmatch_valfrac_0.05_wsampling_pseudobalance_tau_0.95 \
# --model bert --num_classes 3 \
# --epochs 10 --lr 2e-5 --weight-decay 0 --batch_size 32' ENTER


##### CivilComments #####

# tmux send -t base3 'python group_dro.py --name ours_gdro_identityany_valfrac_1_bert_lr_1e-5_wd_1e-2_epoch_5 \
# --dataset jigsaw --bias_name identity_any \
# --split orig --val_frac 1 \
# --sampling group_weight \
# --pseudo_bias fixmatch_valfrac_1_wsampling_pseudobalance_tau_0.95 \
# --model bert --num_classes 2 \
# --epochs 5 --lr 1e-5 --weight-decay 1e-2 --batch_size 16' ENTER