# iterated_kmeans = function(x, K, L_schedule = NULL,
#                            niter = 100, nstart = 10, verb = F)  {
#   if (is.null(L_schedule)) {
#     n = nrow(x)
#     logLmax = (round(log2(n/50))-1)
#     # logLmax = (round(log2(n/K))-1)
#     # logLmax = min(logLmax, 8)
#     L_schedule = K*(2^(logLmax:0))
#   }
#   for (r in 1:length(L_schedule)) {
#     if (verb) cat(paste("run kmeans with L =", L_schedule[r],'\n'))
#     ovfit = kmeans(x, L_schedule[r], iter.max = niter, nstart = nstart)  
#     x = ovfit$centers[ovfit$cluster, ]
#   }
#   ovfit
# }

compute_mis_rate <- function(z, labels, n){ # only works for two clusters
  conf_mat <- nett::compute_confusion_matrix(z, labels)[, 1:2]
  idx <- apply(conf_mat, 1, which.min)
  if (length(unique(idx)) == 1){
    return(min(conf_mat[ ,idx[1]])/n)
  }else{
    return(sum(apply(conf_mat, 1, min))/n)
  }
}
