create_3d_clusters = function(x_list, label, noise_sig) {
  K = length(x_list)
  n = length(label)
  x = matrix(0, n, 3)
  for (k in 1:K) {
    x[label == k, ] = x_list[[k]]
  }
  x = x + mvrnorm(n, mu = c(0,0,0), Sigma = noise_sig*diag(3))
  x = cbind(x, label)
  colnames(x)[1:3] = c("x","y","z")
  dat = as.data.frame(x)
  dat$label = factor(dat$label)
  dat
}

cicle_torus = function(n, R = 3, r = 1, m = 20, 
                       noise_sig = 0, pri=c(1,1)) {
  label <- sample(2, size = n, replace = T, prob = pri/sum(pri))
  ns <- table(label)
  
  # circle = function(t) cbind(R*cos(2*pi*t), R*sin(2*pi*t), 0)
  circle = function(t) cbind(R*cos(t), R*sin(t), 0)
  torus = function(t) cbind((R + r*cos(m*t))*cos(t), (R + r*cos(m*t))*sin(t), r*sin(m*t))
  
  x1 = circle(2*pi*runif(ns[1])) 
  x2 = torus(2*pi*runif(ns[2]))
  
  create_3d_clusters(list(x1,x2), label, noise_sig)
  
  # dat = data.frame(x=x[,1], y=x[,2], z=x[,3], label=1)
  # 
  # dat = rbind(dat, data.frame(x=x[,1], y=x[,2], z=x[,3], label=2))
  # dat$label = factor(dat$label)
  # # dat
  # n = sum(ns)
  # dat[sample(n),]
}

# cicle_torus(c(10,20))

line_circle = function(n, delta = 1, 
                       line_sig = 1, noise_sig = 1, 
                       pri=c(1,1)/2) {
  label <- sample(2, size = n, replace = T, prob = pri/sum(pri))
  ns <- table(label)
  
  theta =  2* pi * runif(ns[1])
  x1 <- cbind(delta*cos(theta), rep(0, ns[1]), delta *sin(theta))
  x2 <- cbind(rep(0, ns[2]), rnorm(ns[2], sd = line_sig), rep(0, ns[2]))
  
  create_3d_clusters(list(x1,x2), label, noise_sig)
  
  # x = matrix(0, n, 3)
  # x[label == 1, ] = x1
  # x[label == 2, ] = x2
  # x = x + mvrnorm(n, mu = c(0,0,0), Sigma = noise_sig*diag(3))
  # x = cbind(x, label)
  # colnames(x)[1:3] = c("x","y","z")
  # dat = as.data.frame(x)
  # dat$label = factor(dat$label)
  # dat
}
