from detectron2.config import CfgNode as CN

def add_humanliker_config(cfg):
    _C = cfg

    _C.MODEL.HUMANLIKER = CN()
    _C.MODEL.HUMANLIKER.NUM_CLASSES = 80
    _C.MODEL.HUMANLIKER.IN_FEATURES = ["p3", "p4", "p5", "p6", "p7"]
    _C.MODEL.HUMANLIKER.FPN_STRIDES = [8, 16, 32, 64, 128]
    _C.MODEL.HUMANLIKER.PRIOR_PROB = 0.01
    _C.MODEL.HUMANLIKER.INFERENCE_TH = 0.05
    _C.MODEL.HUMANLIKER.TL_NMS = False
    _C.MODEL.HUMANLIKER.NMS_TH_TRAIN = 0.6
    _C.MODEL.HUMANLIKER.NMS_TH_TEST = 0.6
    _C.MODEL.HUMANLIKER.PRE_NMS_TOPK_TRAIN = 1000
    _C.MODEL.HUMANLIKER.POST_NMS_TOPK_TRAIN = 100
    _C.MODEL.HUMANLIKER.PRE_NMS_TOPK_TEST = 1000
    _C.MODEL.HUMANLIKER.POST_NMS_TOPK_TEST = 100
    _C.MODEL.HUMANLIKER.NORM = "GN"
    _C.MODEL.HUMANLIKER.USE_DEFORMABLE = False
    _C.MODEL.HUMANLIKER.NUM_CLS_CONVS = 4
    _C.MODEL.HUMANLIKER.NUM_BOX_CONVS = 4
    _C.MODEL.HUMANLIKER.NUM_SHARE_CONVS = 0
    _C.MODEL.HUMANLIKER.LOC_LOSS_TYPE = 'giou'
    _C.MODEL.HUMANLIKER.SIGMOID_CLAMP = 1e-4
    _C.MODEL.HUMANLIKER.HM_MIN_OVERLAP = 0.8
    _C.MODEL.HUMANLIKER.MIN_RADIUS = 4
    _C.MODEL.HUMANLIKER.SOI = [[0, 80], [64, 160], [128, 320], [256, 640], [512, 10000000]]
    _C.MODEL.HUMANLIKER.POS_WEIGHT = 1.
    _C.MODEL.HUMANLIKER.NEG_WEIGHT = 1.
    _C.MODEL.HUMANLIKER.REG_WEIGHT = 2.
    _C.MODEL.HUMANLIKER.HM_FOCAL_BETA = 4
    _C.MODEL.HUMANLIKER.HM_FOCAL_ALPHA = 0.25
    _C.MODEL.HUMANLIKER.LOSS_GAMMA = 2.0
    _C.MODEL.HUMANLIKER.IGNORE_HIGH_FP = -1.
    _C.MODEL.HUMANLIKER.MORE_POS = False
    _C.MODEL.HUMANLIKER.MORE_POS_THRESH = 0.2
    _C.MODEL.HUMANLIKER.MORE_POS_TOPK = 9
    _C.MODEL.HUMANLIKER.NOT_NORM_REG = True
    _C.MODEL.HUMANLIKER.NOT_NMS = False
    _C.MODEL.HUMANLIKER.NO_REDUCE = False

    _C.MODEL.ROI_BOX_HEAD.USE_SIGMOID_CE = False
    _C.MODEL.ROI_BOX_HEAD.PRIOR_PROB = 0.01
    _C.MODEL.ROI_BOX_HEAD.USE_EQL_LOSS = False
    _C.MODEL.ROI_BOX_HEAD.CAT_FREQ_PATH = \
        'datasets/lvis/lvis_v1_train_cat_info.json'
    _C.MODEL.ROI_BOX_HEAD.EQL_FREQ_CAT = 200
    _C.MODEL.ROI_BOX_HEAD.USE_FED_LOSS = False
    _C.MODEL.ROI_BOX_HEAD.FED_LOSS_NUM_CAT = 50
    _C.MODEL.ROI_BOX_HEAD.FED_LOSS_FREQ_WEIGHT = 0.5
    _C.MODEL.ROI_BOX_HEAD.MULT_PROPOSAL_SCORE = False


    _C.MODEL.SWINT = CN()
    _C.MODEL.SWINT.EMBED_DIM = 96
    _C.MODEL.SWINT.OUT_FEATURES = ["stage2", "stage3", "stage4", "stage5"]
    _C.MODEL.SWINT.DEPTHS = [2, 2, 6, 2]
    _C.MODEL.SWINT.NUM_HEADS = [3, 6, 12, 24]
    _C.MODEL.SWINT.WINDOW_SIZE = 7
    _C.MODEL.SWINT.MLP_RATIO = 4
    _C.MODEL.SWINT.DROP_PATH_RATE = 0.2
    _C.MODEL.SWINT.APE = False
    _C.MODEL.BACKBONE.FREEZE_AT = -1


    _C.SOLVER.RESET_ITER = False
    _C.SOLVER.TRAIN_ITER = -1

    _C.INPUT.CUSTOM_AUG = ''
    _C.INPUT.TRAIN_SIZE = 640
    _C.INPUT.TEST_SIZE = 640
    _C.INPUT.SCALE_RANGE = (0.1, 2.)
    # 'default' for fixed short/ long edge, 'square' for max size=INPUT.SIZE
    _C.INPUT.TEST_INPUT_TYPE = 'default'
    _C.INPUT.NOT_CLAMP_BOX = False
    
    _C.DEBUG = False
    _C.SAVE_DEBUG = False
    _C.SAVE_PTH = False
    _C.VIS_THRESH = 0.3
    _C.DEBUG_SHOW_NAME = False
