# A Simple Approach to Adversarial Robustness in Few-shot Image Classification

This repo contains the reference source code for our NeurIPS 2021 submission and is based on the code by [here](https://github.com/wyharveychen/CloserLookFewShot).




## Enviroment
 - Python3
 - [Pytorch](http://pytorch.org/)
 - json

## Getting started
### CUB
* Change directory to `./filelists/CUB`
* run `source ./download_CUB.sh`

### mini-ImageNet
* Change directory to `./filelists/miniImagenet`
* run `source ./download_miniImagenet.sh`

(WARNING: This would download the 155G ImageNet dataset. You can comment out correponded line 5-6 in `download_miniImagenet.sh` if you already have one.)


## Train
Run
```python ./train_adv_wa.py --dataset [DATASETNAME] --model [BACKBONENAME] --method [METHODNAME] [--OPTIONARG]```

For example, run `python ./train_adv_wa.py --dataset miniImagenet --model ResNet18 --method baseline --train_aug --num_classes 64 --lr 0.1 --weight_decay 1e-4`
Commands below follow this example, and please refer to io_utils.py for additional options.


## Standard Accuracy
Run
```python ./test_adv_wa_nn.py --dataset miniImagenet --model ResNet18 --method baseline --train_aug --checkpoint_dir [CHECKPOINT_PATH]```
## Robust Accuracy
Run
```python ./test_adv_wa_nn.py --dataset miniImagenet --model ResNet18 --method baseline --train_aug --checkpoint_dir [CHECKPOINT_PATH] --adv_eval```
## Results
* The test results will be recorded in `./record/results.txt`
