import torch
import torch.nn as nn
import torch.nn.functional as F

# pylint:disable=no-member,invalid-unary-operand-type


# @torch.jit.script
def h_swish(x):
    """Hard Swish: MobileNetV3 https://arxiv.org/pdf/1905.02244.pdf
    """
    return x * F.relu6(x + 3) / 6


def swish(x):
    return x * torch.sigmoid_(x)


ACT2FN = {"gelu": F.gelu, "h_swish": h_swish, "swish": swish, "relu": F.relu, "sin": torch.sin}