# Equiformer: Equivariant Graph Attention Transformer for 3D Atomistic Graphs


## Content ##
0. [Getting Started](#getting-started)
0. [Training](#training)
0. [Acknowledgement](#acknowledgement)


## Getting Started ##


### Environment 

We use conda to install required packages:
```
    conda env create -f env/setup.yml
```

This will create a new environment called `equiformer`.
Then, we activate the environment:
```
    export PYTHONNOUSERSITE=True    # prevent using packages from base
    conda activate equiformer
```

Besides, [`env/detail.yml`](env/env_details.yml) specifies versions of all packages.

After setting up the environment, clone OC20 repo and install `ocpmodels`:
```
    git clone https://github.com/Open-Catalyst-Project/ocp
    cd ocp
    git checkout b5a197f
    pip install -e .
```

The version of `ocpmodels` used here is `0.0.3`.
The correpsonding version of GitHub repo is [here](https://github.com/Open-Catalyst-Project/ocp/tree/b5a197fc3c79a9a5a787aabaa02979be53d296b7).


### QM9

The dataset of QM9 will be automatically downloaded when running training.


### OC20

We will release the training code for OC20 in the future.



## Training ##


### QM9

We provide training scripts under [`scripts/train/qm9/equiformer`](scripts/train/qm9/equiformer).
For example, we can train Equiformer for the task of `alpha` by running:
```
    sh scripts/train/qm9/equiformer/target@1.sh
```

The QM9 dataset will be downloaded automatically as we run training for the first time.

The target number for different regression tasks can be found [here](https://pytorch-geometric.readthedocs.io/en/latest/modules/datasets.html?highlight=qm9#torch_geometric.datasets.QM9).

We also provide the code for training Equiformer with linear messages and dot product attention.
To train Equiformer with linear messages, replace `--model-name 'graph_attention_transformer_nonlinear_l2'` with `--model-name 'graph_attention_transformer_l2'` in training scripts.
The training scripts for Equiformer with linear messages and dot product attention can be found in [`scripts/train/qm9/dp_equiformer`](scripts/train/qm9/dp_equiformer).


### OC20

We will release the training code for OC20 in the future.



## Acknowledgement ##

Our implementation is based on PyTorch, PyG, e3nn, timm and SEGNN.