import pandas as pd 
import numpy as np 

datasets = [
    "australian", "breast-cancer", "cod-rna", "diabetes", "german.numer",
    "phishing", "sonar_scale", "splice", "heart", "ionosphere_scale",
    "mushrooms"]

table = pd.DataFrame(columns=["train_dim",
                    "test_dim",
                    "compo_train_dim",
                    "compo_test_dim",
                    "norm_train_dim",
                    "norm_test_dim"
                     ])

for dataset in datasets:
    df = pd.read_csv("../log/"+"intrinsics_"+dataset+".csv")
    mean = df.mean(axis=0)
    mean.rename(dataset)
    #print(pd.Series(mean, name=dataset))
    table.loc[dataset] = pd.Series(mean, name=dataset)
    table['compo_dim_ratio'] = table['compo_test_dim'] / table['norm_train_dim']
    table['norm_intrinsic_dim_ratio'] = table['norm_test_dim'] / table['norm_train_dim']
    table['intrinsic_dim_ratio'] = table['train_dim'] / table['norm_train_dim']
    table['intrinsic_dim_ratio_change'] = (
        table['norm_intrinsic_dim_ratio'] - table['intrinsic_dim_ratio'])

#for col in table:
#    if "norm_train_dim" not in col and "train_dim" not in col and "norm_test_dim" not in col or "compo" in col:
#        table.drop(col, inplace=True, axis=1)
table = table[['train_dim', 'intrinsic_dim_ratio', 'norm_intrinsic_dim_ratio', 'intrinsic_dim_ratio_change']]
table = table.sort_values('intrinsic_dim_ratio_change', ascending=False)

print((table.round(2)).to_latex())
